/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.List;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class ModuleDisableCrafting
extends OCMModule {
    private List<Material> denied;
    private String message;

    public ModuleDisableCrafting(OCMMain plugin) {
        super(plugin, "disable-crafting");
        this.reload();
    }

    @Override
    public void reload() {
        this.denied = ConfigUtils.loadMaterialList(this.module(), "denied");
        this.message = this.module().getBoolean("showMessage") ? this.module().getString("message") : null;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareItemCraft(PrepareItemCraftEvent e) {
        List viewers = e.getViewers();
        if (viewers.size() == 0) {
            return;
        }
        if (!this.isEnabled((HumanEntity)viewers.get(0))) {
            return;
        }
        CraftingInventory inv = e.getInventory();
        ItemStack result = inv.getResult();
        if (result != null && this.denied.contains(result.getType())) {
            inv.setResult(null);
            if (this.message != null) {
                viewers.forEach(viewer -> Messenger.send((CommandSender)viewer, this.message, new Object[0]));
            }
        }
    }
}

