/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XSound;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.Plugin;

public class ModuleAttackSounds
extends OCMModule {
    private final ProtocolManager protocolManager;
    private final SoundListener soundListener;
    private final Set<String> blockedSounds;

    public ModuleAttackSounds(OCMMain plugin) {
        super(plugin, "disable-attack-sounds");
        this.protocolManager = this.plugin.getProtocolManager();
        this.soundListener = new SoundListener((Plugin)this.plugin);
        this.blockedSounds = new HashSet<String>();
        this.reload();
    }

    @Override
    public void reload() {
        this.blockedSounds.clear();
        this.blockedSounds.addAll(this.getBlockedSounds());
        if (this.isEnabled()) {
            this.protocolManager.addPacketListener((PacketListener)this.soundListener);
        } else {
            this.protocolManager.removePacketListener((PacketListener)this.soundListener);
        }
    }

    private Collection<String> getBlockedSounds() {
        List fromConfig = this.module().getStringList("blocked-sound-names");
        HashSet<String> processed = new HashSet<String>();
        for (String soundName : fromConfig) {
            Optional<XSound> xSound = XSound.matchXSound(soundName);
            if (xSound.isPresent()) {
                Object processedName;
                Sound sound = xSound.get().parseSound();
                if (sound != null) {
                    try {
                        Method getKeyMethod = Sound.class.getMethod("getKey", new Class[0]);
                        Object key = getKeyMethod.invoke((Object)sound, new Object[0]);
                        processed.add(key.toString());
                        continue;
                    }
                    catch (Exception getKeyMethod) {
                        // empty catch block
                    }
                }
                if (!((String)(processedName = soundName.toLowerCase(Locale.ROOT).replace('_', '.'))).contains(":")) {
                    processedName = "minecraft:" + (String)processedName;
                }
                processed.add((String)processedName);
                continue;
            }
            Messenger.warn("Invalid sound name in config: " + soundName, new Object[0]);
        }
        return processed;
    }

    private class SoundListener
    extends PacketAdapter {
        private boolean disabledDueToError;

        public SoundListener(Plugin plugin) {
            super(plugin, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT});
        }

        public void onPacketSending(PacketEvent packetEvent) {
            if (this.disabledDueToError || !ModuleAttackSounds.this.isEnabled((HumanEntity)packetEvent.getPlayer())) {
                return;
            }
            try {
                Method getLocationMethod;
                Object unwrappedEvent;
                PacketContainer packetContainer = packetEvent.getPacket();
                Object nmsSoundEvent = packetContainer.getModifier().read(0);
                if (nmsSoundEvent == null) {
                    return;
                }
                Object soundEventObject = nmsSoundEvent;
                Method valueMethod = Reflector.getMethod(nmsSoundEvent.getClass(), "value");
                if (valueMethod != null && (unwrappedEvent = Reflector.invokeMethod(valueMethod, nmsSoundEvent, new Object[0])) != null) {
                    soundEventObject = unwrappedEvent;
                }
                if ((getLocationMethod = Reflector.getMethod(soundEventObject.getClass(), "getLocation")) == null) {
                    getLocationMethod = Reflector.getMethod(soundEventObject.getClass(), "location");
                }
                if (getLocationMethod == null) {
                    throw new IllegalStateException("Could not find sound location method on " + soundEventObject.getClass().getName());
                }
                Object resourceLocation = Reflector.invokeMethod(getLocationMethod, soundEventObject, new Object[0]);
                String soundName = resourceLocation.toString();
                if (ModuleAttackSounds.this.blockedSounds.contains(soundName)) {
                    packetEvent.setCancelled(true);
                    ModuleAttackSounds.this.debug("Blocked sound " + soundName, (CommandSender)packetEvent.getPlayer());
                }
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sound packets. Please report it along with the following exception on github.", new Object[0]);
            }
        }
    }
}

