/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.constraint;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.ReflectiveHandle;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.XAccessFlag;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.constraint.ReflectiveConstraint;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum ClassTypeConstraint implements ReflectiveConstraint
{
    INTERFACE{

        @Override
        protected boolean test(Class<?> clazz) {
            return clazz.isInterface();
        }
    }
    ,
    ABSTRACT{

        @Override
        protected boolean test(Class<?> clazz) {
            return XAccessFlag.ABSTRACT.isSet(clazz.getModifiers());
        }
    }
    ,
    ENUM{

        @Override
        protected boolean test(Class<?> clazz) {
            return clazz.isEnum();
        }
    }
    ,
    RECORD{
        private final MethodHandle isRecord;
        {
            MethodHandle isRecord0;
            try {
                isRecord0 = MethodHandles.lookup().findVirtual(Class.class, "isRecord", MethodType.methodType(Boolean.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                isRecord0 = null;
            }
            this.isRecord = isRecord0;
        }

        @Override
        protected boolean test(Class<?> clazz) {
            try {
                return this.isRecord.invoke(clazz);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot use Class#isRecord", e);
            }
        }
    }
    ,
    ANNOTATION{

        @Override
        protected boolean test(Class<?> clazz) {
            return clazz.isAnnotation();
        }
    };


    protected abstract boolean test(Class<?> var1);

    @Override
    public ReflectiveConstraint.Result appliesTo(ReflectiveHandle<?> handle, Object jvm) {
        if (jvm instanceof Class) {
            return ReflectiveConstraint.Result.of(this.test((Class)jvm));
        }
        return ReflectiveConstraint.Result.INCOMPATIBLE;
    }

    @Override
    public String category() {
        return "ClassType";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "::" + this.name();
    }
}

