/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics;

import java.io.File;
import java.io.IOException;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.configuration.file.YamlConfiguration;

public class OCMConfigHandler {
    private final String CONFIG_NAME = "config.yml";
    private final OCMMain plugin;

    public OCMConfigHandler(OCMMain instance) {
        this.plugin = instance;
    }

    public void upgradeConfig() {
        File backup = this.getFile("config-backup.yml");
        if (backup.exists()) {
            backup.delete();
        }
        if (Reflector.versionIsNewerOrEqualTo(1, 18, 1) || Config.getConfig().getBoolean("force-below-1-18-1-config-upgrade", false)) {
            this.plugin.getLogger().warning("Config version does not match, upgrading old config");
            File configFile = this.getFile("config.yml");
            if (!configFile.renameTo(backup)) {
                this.plugin.getLogger().severe("Could not back up old config file. Aborting config upgrade.");
                return;
            }
            this.plugin.saveResource("config.yml", true);
            YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)backup);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
            for (String key : newConfig.getKeys(true)) {
                if (key.equals("config-version") || newConfig.isConfigurationSection(key) || !oldConfig.contains(key) || oldConfig.isConfigurationSection(key)) continue;
                newConfig.set(key, oldConfig.get(key));
            }
            try {
                newConfig.save(configFile);
                this.plugin.getLogger().info("Config has been updated. A backup of your old config is available at config-backup.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save upgraded config. It has been restored from backup.");
                e.printStackTrace();
                backup.renameTo(configFile);
            }
        } else {
            this.plugin.getLogger().warning("Config version does not match, backing up old config and creating a new one");
            File configFile = this.getFile("config.yml");
            configFile.renameTo(backup);
        }
        this.setupConfigIfNotPresent();
    }

    public void setupConfigIfNotPresent() {
        if (!this.doesConfigExist()) {
            this.plugin.saveDefaultConfig();
            this.plugin.getLogger().info("Config file generated");
        }
    }

    public YamlConfiguration getConfig(String fileName) {
        return YamlConfiguration.loadConfiguration((File)this.getFile(fileName));
    }

    public File getFile(String fileName) {
        return new File(this.plugin.getDataFolder(), fileName.replace('/', File.separatorChar));
    }

    public boolean doesConfigExist() {
        return this.getFile("config.yml").exists();
    }
}

