/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.util.Objects;
import java.util.logging.Level;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.TextUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Messenger {
    public static final String HORIZONTAL_BAR = String.valueOf(ChatColor.STRIKETHROUGH) + "----------------------------------------------------";
    private static OCMMain plugin;
    private static boolean DEBUG_ENABLED;
    private static String PREFIX;

    public static void initialise(OCMMain plugin) {
        Messenger.plugin = plugin;
    }

    public static void reloadConfig(boolean debugEnabled, String prefix) {
        DEBUG_ENABLED = debugEnabled;
        PREFIX = prefix;
    }

    public static void info(String message, Object ... args) {
        plugin.getLogger().info(TextUtils.stripColour(String.format(message, args)));
    }

    public static void warn(Throwable e, String message, Object ... args) {
        plugin.getLogger().log(Level.WARNING, TextUtils.stripColour(String.format(message, args)), e);
    }

    public static void warn(String message, Object ... args) {
        plugin.getLogger().log(Level.WARNING, TextUtils.stripColour(String.format(message, args)));
    }

    public static void sendNoPrefix(CommandSender sender, String message, Object ... args) {
        Objects.requireNonNull(sender, "sender cannot be null!");
        Objects.requireNonNull(message, "message cannot be null!");
        if (message.isEmpty()) {
            return;
        }
        sender.sendMessage(TextUtils.colourise(String.format(message, args)));
    }

    private static void sendWithPrefix(CommandSender sender, String message, String prefix, Object ... args) {
        if (message.isEmpty()) {
            return;
        }
        Messenger.sendNoPrefix(sender, prefix + " " + message, args);
    }

    public static void send(CommandSender sender, String message, Object ... args) {
        Messenger.sendWithPrefix(sender, message, PREFIX, args);
    }

    private static void sendDebugMessage(CommandSender sender, String message, Object ... args) {
        Messenger.sendWithPrefix(sender, message, "&1[Debug]&r", args);
    }

    public static void debug(String message, Throwable throwable) {
        if (DEBUG_ENABLED) {
            plugin.getLogger().log(Level.INFO, message, throwable);
        }
    }

    public static void debug(String message, Object ... args) {
        if (DEBUG_ENABLED) {
            Messenger.info("[DEBUG] " + message, args);
        }
    }

    public static void debug(CommandSender sender, String message, Object ... args) {
        if (DEBUG_ENABLED) {
            Messenger.sendDebugMessage(sender, message, args);
        }
    }

    static {
        DEBUG_ENABLED = false;
        PREFIX = "&6[OCM]&r";
    }
}

