/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kernitus.plugin.OldCombatMechanics.ModuleLoader;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.EntityDamageByEntityListener;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private static final String CONFIG_NAME = "config.yml";
    private static OCMMain plugin;
    private static FileConfiguration config;
    private static final Map<String, Set<String>> modesets;
    private static final Map<UUID, Set<String>> worlds;

    public static void initialise(OCMMain plugin) {
        Config.plugin = plugin;
        config = plugin.getConfig();
    }

    private static boolean checkConfigVersion() {
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource(CONFIG_NAME))));
        if (config.getInt("config-version") != defaultConfig.getInt("config-version")) {
            plugin.upgradeConfig();
            Config.reload();
            return true;
        }
        return false;
    }

    public static void reload() {
        if (plugin.doesConfigExist()) {
            plugin.reloadConfig();
            config = plugin.getConfig();
        } else {
            plugin.upgradeConfig();
        }
        if (Config.checkConfigVersion()) {
            return;
        }
        Messenger.reloadConfig(config.getBoolean("debug.enabled"), config.getString("message-prefix"));
        WeaponDamages.initialise(plugin);
        EntityDamageByEntityListener EDBEL = EntityDamageByEntityListener.getINSTANCE();
        if (EDBEL != null) {
            EDBEL.setEnabled(Config.moduleEnabled("old-tool-damage") || Config.moduleEnabled("old-potion-effects") || Config.moduleEnabled("old-critical-hits"));
        }
        Config.reloadModesets();
        Config.reloadWorlds();
        ModuleLoader.toggleModules();
        ModuleLoader.getModules().forEach(module -> {
            try {
                module.reload();
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error reloading module '" + module.toString() + "'", e);
            }
        });
    }

    private static void reloadModesets() {
        modesets.clear();
        Set moduleNames = ModuleLoader.getModules().stream().map(OCMModule::getConfigName).collect(Collectors.toSet());
        ConfigurationSection modesetsSection = config.getConfigurationSection("modesets");
        HashSet modulesInModesets = new HashSet();
        for (String key : modesetsSection.getKeys(false)) {
            List moduleList = modesetsSection.getStringList(key);
            HashSet moduleSet = new HashSet(moduleList);
            modesets.put(key, moduleSet);
            modulesInModesets.addAll(moduleSet);
        }
        HashSet modulesNotInAnyModeset = new HashSet(moduleNames);
        modulesNotInAnyModeset.removeAll(modulesInModesets);
        for (Set<String> modeSet : modesets.values()) {
            modeSet.addAll(modulesNotInAnyModeset);
        }
    }

    private static void reloadWorlds() {
        worlds.clear();
        ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
        for (String worldName : worldsSection.getKeys(false)) {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                Messenger.warn("Configured world " + worldName + " not found, skipping (might be loaded later?)...", new Object[0]);
                continue;
            }
            Config.addWorld(world, worldsSection);
        }
    }

    public static void addWorld(World world) {
        ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
        Config.addWorld(world, worldsSection);
    }

    public static void addWorld(World world, ConfigurationSection worldsSection) {
        LinkedHashSet modesetsSet = new LinkedHashSet(worldsSection.getStringList(world.getName()));
        worlds.put(world.getUID(), modesetsSet);
    }

    public static void removeWorld(World world) {
        worlds.remove(world.getUID());
    }

    @Nullable
    public static Set<String> getDefaultModeset(UUID worldId) {
        String modesetName;
        if (!worlds.containsKey(worldId)) {
            return null;
        }
        Set<String> set = worlds.get(worldId);
        if (set == null || set.isEmpty()) {
            return null;
        }
        Iterator<String> iterator = set.iterator();
        if (iterator.hasNext() && modesets.containsKey(modesetName = iterator.next())) {
            return modesets.get(modesetName);
        }
        return null;
    }

    public static boolean moduleEnabled(String moduleName, World world) {
        ConfigurationSection section = config.getConfigurationSection(moduleName);
        if (section == null) {
            plugin.getLogger().warning("Tried to check module '" + moduleName + "', but it didn't exist!");
            return false;
        }
        if (!section.getBoolean("enabled")) {
            return false;
        }
        if (world == null) {
            return true;
        }
        Set<String> defaultModeset = Config.getDefaultModeset(world.getUID());
        if (defaultModeset == null) {
            return true;
        }
        return defaultModeset.contains(moduleName);
    }

    public static boolean moduleEnabled(String moduleName) {
        return Config.moduleEnabled(moduleName, null);
    }

    public static boolean debugEnabled() {
        return Config.moduleEnabled("debug", null);
    }

    public static boolean moduleSettingEnabled(String moduleName, String moduleSettingName) {
        return config.getBoolean(moduleName + "." + moduleSettingName);
    }

    public static FileConfiguration getConfig() {
        return plugin.getConfig();
    }

    public static Map<String, Set<String>> getModesets() {
        return modesets;
    }

    public static Map<UUID, Set<String>> getWorlds() {
        return worlds;
    }

    static {
        modesets = new HashMap<String, Set<String>>();
        worlds = new HashMap<UUID, Set<String>>();
    }
}

