/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.updater;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kernitus.plugin.OldCombatMechanics.OCMMain;

public class VersionChecker {
    public static boolean shouldUpdate(String remoteVersion) {
        return VersionChecker.isUpdateOut(remoteVersion, OCMMain.getVersion());
    }

    private static boolean isUpdateOut(String remoteVersion, String localVersion) {
        int[] testVer = VersionChecker.getVersionNumbers(remoteVersion);
        int[] baseVer = VersionChecker.getVersionNumbers(localVersion);
        for (int i = 0; i < testVer.length; ++i) {
            if (testVer[i] == baseVer[i]) continue;
            return testVer[i] > baseVer[i];
        }
        return false;
    }

    private static int[] getVersionNumbers(String ver) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:-(beta|SNAPSHOT)(\\d*))?", 2).matcher(ver);
        if (!m.matches()) {
            throw new IllegalArgumentException("Plugin version formatted wrong!");
        }
        int[] nArray = new int[4];
        nArray[0] = Integer.parseInt(m.group(1));
        nArray[1] = Integer.parseInt(m.group(2));
        int n = nArray[2] = m.group(3) == null ? 0 : Integer.parseInt(m.group(3));
        nArray[3] = m.group(4) == null ? Integer.MAX_VALUE : (m.group(5).isEmpty() ? 0 : Integer.parseInt(m.group(5)));
        return nArray;
    }
}

