/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerStorage;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public abstract class OCMModule
implements Listener {
    protected OCMMain plugin;
    private final String configName;
    private final String moduleName;

    protected OCMModule(OCMMain plugin, String configName) {
        this.plugin = plugin;
        this.configName = configName;
        this.moduleName = this.getClass().getSimpleName();
    }

    public boolean isEnabled() {
        return Config.moduleEnabled(this.configName, null);
    }

    public boolean isEnabled(World world) {
        return Config.moduleEnabled(this.configName, world);
    }

    public boolean isEnabled(@NotNull HumanEntity humanEntity) {
        World world = humanEntity.getWorld();
        String modesetName = PlayerStorage.getPlayerData(humanEntity.getUniqueId()).getModesetForWorld(world.getUID());
        if (modesetName == null) {
            this.debug("No modeset found!", (CommandSender)humanEntity);
            this.debug("No modeset found for " + humanEntity.getName());
            return this.isEnabled(world);
        }
        Set<String> modeset = Config.getModesets().get(modesetName);
        return modeset != null && modeset.contains(this.configName);
    }

    public boolean isEnabled(@NotNull Entity entity) {
        if (entity instanceof HumanEntity) {
            return this.isEnabled((HumanEntity)entity);
        }
        return this.isEnabled(entity.getWorld());
    }

    public boolean isEnabled(@NotNull Entity attacker, @NotNull Entity defender) {
        if (attacker instanceof HumanEntity) {
            return this.isEnabled((HumanEntity)attacker);
        }
        if (defender instanceof HumanEntity) {
            return this.isEnabled((HumanEntity)defender);
        }
        return this.isEnabled(defender.getWorld());
    }

    public boolean isSettingEnabled(String name) {
        return this.plugin.getConfig().getBoolean(this.configName + "." + name, false);
    }

    public ConfigurationSection module() {
        return this.plugin.getConfig().getConfigurationSection(this.configName);
    }

    public void reload() {
    }

    public void onModesetChange(Player player) {
    }

    protected void debug(String text) {
        Messenger.debug("[" + this.moduleName + "] " + text, new Object[0]);
    }

    protected void debug(String text, CommandSender sender) {
        if (Config.debugEnabled()) {
            Messenger.sendNoPrefix(sender, "&8&l[&fDEBUG&8&l][&f" + this.moduleName + "&8&l]&7 " + text, new Object[0]);
        }
    }

    public String toString() {
        return Arrays.stream(this.configName.split("-")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase(Locale.ROOT)).reduce((a, b) -> a + " " + b).orElse(this.configName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getConfigName() {
        return this.configName;
    }
}

