/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.ArrayList;
import java.util.List;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.NewWeaponDamage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleSwordSweep
extends OCMModule {
    private final List<Location> sweepLocations = new ArrayList<Location>();
    private EntityDamageEvent.DamageCause sweepDamageCause;
    private BukkitTask task;

    public ModuleSwordSweep(OCMMain plugin) {
        super(plugin, "disable-sword-sweep");
        try {
            this.sweepDamageCause = EntityDamageEvent.DamageCause.valueOf((String)"ENTITY_SWEEP_ATTACK");
        }
        catch (IllegalArgumentException e) {
            this.sweepDamageCause = null;
        }
        this.reload();
    }

    @Override
    public void reload() {
        if (this.sweepDamageCause != null) {
            return;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this.sweepLocations::clear, 0L, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamaged(EntityDamageByEntityEvent e) {
        Entity damager = e.getDamager();
        if (!(damager instanceof Player)) {
            return;
        }
        if (!this.isEnabled(damager, e.getEntity())) {
            return;
        }
        if (this.sweepDamageCause != null) {
            if (e.getCause() == this.sweepDamageCause) {
                e.setCancelled(true);
                this.debug("Sweep cancelled", (CommandSender)damager);
            }
            return;
        }
        Player attacker = (Player)e.getDamager();
        ItemStack weapon = attacker.getInventory().getItemInMainHand();
        if (this.isHoldingSword(weapon.getType())) {
            this.onSwordAttack(e, attacker, weapon);
        }
    }

    private void onSwordAttack(EntityDamageByEntityEvent e, Player attacker, ItemStack weapon) {
        Location attackerLocation = attacker.getLocation();
        int level = 0;
        try {
            level = weapon.getEnchantmentLevel(Enchantment.SWEEPING_EDGE);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        float damage = NewWeaponDamage.getDamage(weapon.getType()) * (float)level / (float)(level + 1) + 1.0f;
        if (e.getDamage() == (double)damage) {
            if (this.sweepLocations.contains(attackerLocation)) {
                this.debug("Cancelling sweep...", (CommandSender)attacker);
                e.setCancelled(true);
            }
        } else {
            this.sweepLocations.add(attackerLocation);
        }
    }

    private boolean isHoldingSword(Material mat) {
        return mat.toString().endsWith("_SWORD");
    }
}

