/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionTypeCompat;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ModuleOldPotionEffects
extends OCMModule {
    private static final Set<PotionTypeCompat> EXCLUDED_POTION_TYPES = Set.of(new PotionTypeCompat("AWKWARD"), new PotionTypeCompat("MUNDANE"), new PotionTypeCompat("THICK"), new PotionTypeCompat("WATER"), new PotionTypeCompat("HARMING"), new PotionTypeCompat("STRONG_HARMING"), new PotionTypeCompat("HEALING"), new PotionTypeCompat("STRONG_HEALING"), new PotionTypeCompat("UNCRAFTABLE"));
    private Map<PotionTypeCompat, PotionDurations> durations;

    public ModuleOldPotionEffects(OCMMain plugin) {
        super(plugin, "old-potion-effects");
        this.reload();
    }

    @Override
    public void reload() {
        this.durations = ConfigUtils.loadPotionDurationsList(this.module());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerDrinksPotion(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        ItemStack potionItem = event.getItem();
        if (potionItem.getType() != Material.POTION) {
            return;
        }
        this.adjustPotion(potionItem, false);
        event.setItem(potionItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionDispense(BlockDispenseEvent event) {
        if (!this.isEnabled(event.getBlock().getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionThrow(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    private void adjustPotion(ItemStack potionItem, boolean splash) {
        List<PotionEffectType> potionEffects;
        int amplifier;
        PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
        if (potionMeta == null) {
            return;
        }
        PotionTypeCompat potionTypeCompat = PotionTypeCompat.fromPotionMeta(potionMeta);
        if (EXCLUDED_POTION_TYPES.contains(potionTypeCompat)) {
            return;
        }
        Integer duration = this.getPotionDuration(potionTypeCompat, splash);
        if (duration == null) {
            this.debug("Potion type " + potionTypeCompat.getNewName() + " not found in config, leaving as is...");
            return;
        }
        int n = amplifier = potionTypeCompat.isStrong() ? 1 : 0;
        if (potionTypeCompat.equals(new PotionTypeCompat("WEAKNESS"))) {
            amplifier = -1;
        }
        PotionType potionType = potionTypeCompat.getType();
        try {
            potionEffects = potionType.getPotionEffects().stream().map(PotionEffect::getType).toList();
        }
        catch (NoSuchMethodError e) {
            potionEffects = List.of(potionType.getEffectType());
        }
        for (PotionEffectType effectType : potionEffects) {
            potionMeta.addCustomEffect(new PotionEffect(effectType, duration.intValue(), amplifier), false);
        }
        try {
            potionMeta.setBasePotionType(PotionType.WATER);
        }
        catch (NoSuchMethodError e) {
            potionMeta.setBasePotionData(new PotionData(PotionType.WATER));
        }
        potionItem.setItemMeta((ItemMeta)potionMeta);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageByEntity(OCMEntityDamageByEntityEvent event) {
        double strengthModifier;
        Entity damager = event.getDamager();
        if (!this.isEnabled(damager, event.getDamagee())) {
            return;
        }
        if (event.hasWeakness()) {
            event.setIsWeaknessModifierMultiplier(this.module().getBoolean("weakness.multiplier"));
            double newWeaknessModifier = this.module().getDouble("weakness.modifier");
            event.setWeaknessModifier(newWeaknessModifier);
            event.setWeaknessLevel(1);
            this.debug("Old weakness modifier: " + event.getWeaknessLevel() + " New: " + newWeaknessModifier, (CommandSender)damager);
        }
        if ((strengthModifier = event.getStrengthModifier()) > 0.0) {
            event.setIsStrengthModifierMultiplier(this.module().getBoolean("strength.multiplier"));
            event.setIsStrengthModifierAddend(this.module().getBoolean("strength.addend"));
            double newStrengthModifier = this.module().getDouble("strength.modifier");
            event.setStrengthModifier(newStrengthModifier);
            this.debug("Old strength modifier: " + strengthModifier + " New: " + newStrengthModifier, (CommandSender)damager);
        }
    }

    private Integer getPotionDuration(PotionTypeCompat potionTypeCompat, boolean splash) {
        PotionDurations potionDurations = this.durations.get(potionTypeCompat);
        if (potionDurations == null) {
            return null;
        }
        int duration = splash ? potionDurations.splash() : potionDurations.drinkable();
        this.debug("Potion type: " + potionTypeCompat.getNewName() + " Duration: " + duration + " ticks");
        return duration;
    }
}

