/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ModuleAttackFrequency
extends OCMModule {
    private static final int DEFAULT_DELAY = 20;
    private static int playerDelay;
    private static int mobDelay;

    public ModuleAttackFrequency(OCMMain plugin) {
        super(plugin, "attack-frequency");
        this.reload();
    }

    @Override
    public void reload() {
        playerDelay = this.module().getInt("playerDelay");
        mobDelay = this.module().getInt("mobDelay");
        Bukkit.getWorlds().forEach(world -> world.getLivingEntities().forEach(livingEntity -> {
            if (livingEntity instanceof Player) {
                livingEntity.setMaximumNoDamageTicks(this.isEnabled((HumanEntity)((Player)livingEntity)) ? playerDelay : 20);
            } else {
                livingEntity.setMaximumNoDamageTicks(this.isEnabled((World)world) ? mobDelay : 20);
            }
        }));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.isEnabled((HumanEntity)player)) {
            this.setDelay(player, playerDelay);
        }
    }

    @EventHandler
    public void onPlayerLogout(PlayerQuitEvent e) {
        this.setDelay(e.getPlayer(), 20);
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent e) {
        Player player;
        this.setDelay(player, this.isEnabled((HumanEntity)(player = e.getPlayer())) ? playerDelay : 20);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player;
        this.setDelay(player, this.isEnabled((HumanEntity)(player = e.getPlayer())) ? playerDelay : 20);
    }

    private void setDelay(Player player, int delay) {
        player.setMaximumNoDamageTicks(delay);
        this.debug("Set hit delay to " + delay, (CommandSender)player);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        LivingEntity livingEntity = e.getEntity();
        World world = livingEntity.getWorld();
        if (this.isEnabled(world)) {
            livingEntity.setMaximumNoDamageTicks(mobDelay);
        }
    }

    @EventHandler
    public void onEntityTeleportEvent(EntityTeleportEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        World fromWorld = e.getFrom().getWorld();
        Location toLocation = e.getTo();
        if (toLocation == null) {
            return;
        }
        World toWorld = toLocation.getWorld();
        if (fromWorld.getUID() != toWorld.getUID()) {
            livingEntity.setMaximumNoDamageTicks(this.isEnabled(toWorld) ? mobDelay : 20);
        }
    }
}

