/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.constraint;

import java.lang.reflect.Member;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.ReflectiveHandle;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.XAccessFlag;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.constraint.ReflectiveConstraint;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum VisibilityConstraint implements ReflectiveConstraint
{
    PUBLIC(XAccessFlag.PUBLIC),
    PRIVATE(XAccessFlag.PRIVATE),
    PROTECTED(XAccessFlag.PROTECTED);

    private final XAccessFlag accessFlag;

    private VisibilityConstraint(XAccessFlag accessFlag) {
        this.accessFlag = accessFlag;
    }

    @ApiStatus.Internal
    public XAccessFlag getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public ReflectiveConstraint.Result appliesTo(ReflectiveHandle<?> handle, Object jvm) {
        int mods;
        if (jvm instanceof Class) {
            mods = ((Class)jvm).getModifiers();
            if (this == PRIVATE) {
                return ReflectiveConstraint.Result.INCOMPATIBLE;
            }
            if (this == PROTECTED) {
                return ReflectiveConstraint.Result.of(!XAccessFlag.PUBLIC.isSet(mods));
            }
        } else if (jvm instanceof Member) {
            mods = ((Member)jvm).getModifiers();
        } else {
            return ReflectiveConstraint.Result.INCOMPATIBLE;
        }
        return ReflectiveConstraint.Result.of(this.accessFlag.isSet(mods));
    }

    @Override
    public String category() {
        return "Visibility";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "::" + this.name();
    }
}

