/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XAttribute;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionEffectTypeCompat;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.VersionCompatUtils;
import kernitus.plugin.OldCombatMechanics.versions.enchantments.EnchantmentCompat;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class DefenceUtils {
    private static final double REDUCTION_PER_ARMOUR_POINT = 0.04;
    private static final double REDUCTION_PER_RESISTANCE_LEVEL = 0.2;
    private static final Set<EntityDamageEvent.DamageCause> ARMOUR_IGNORING_CAUSES = EnumSet.of(EntityDamageEvent.DamageCause.FIRE_TICK, new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.SUFFOCATION, EntityDamageEvent.DamageCause.DROWNING, EntityDamageEvent.DamageCause.STARVATION, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.CUSTOM, EntityDamageEvent.DamageCause.MAGIC, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.FLY_INTO_WALL, EntityDamageEvent.DamageCause.DRAGON_BREATH});
    private static final SpigotFunctionChooser<LivingEntity, Object, Double> getAbsorptionAmount;

    public static void calculateDefenceDamageReduction(LivingEntity damagedEntity, Map<EntityDamageEvent.DamageModifier, Double> damageModifiers, EntityDamageEvent.DamageCause damageCause, boolean randomness) {
        double armourPoints = damagedEntity.getAttribute((Attribute)XAttribute.ARMOR.get()).getValue();
        double armourReductionFactor = Math.min(1.0, armourPoints * 0.04);
        double currentDamage = damageModifiers.get(EntityDamageEvent.DamageModifier.BASE) + damageModifiers.getOrDefault(EntityDamageEvent.DamageModifier.HARD_HAT, 0.0) + damageModifiers.getOrDefault(EntityDamageEvent.DamageModifier.BLOCKING, 0.0);
        if (damageModifiers.containsKey(EntityDamageEvent.DamageModifier.ARMOR)) {
            double armourReduction = 0.0;
            if (!(ARMOUR_IGNORING_CAUSES.contains(damageCause) || Reflector.versionIsNewerOrEqualTo(1, 19, 0) && damageCause == EntityDamageEvent.DamageCause.CONTACT && damagedEntity.getLocation().getBlock().getType() == Material.POINTED_DRIPSTONE)) {
                armourReduction = currentDamage * -armourReductionFactor;
            }
            damageModifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armourReduction);
            currentDamage += armourReduction;
        }
        if (damageCause != EntityDamageEvent.DamageCause.STARVATION) {
            if (damageModifiers.containsKey(EntityDamageEvent.DamageModifier.RESISTANCE) && damageCause != EntityDamageEvent.DamageCause.VOID && damagedEntity.hasPotionEffect(PotionEffectTypeCompat.RESISTANCE.get())) {
                int level = damagedEntity.getPotionEffect(PotionEffectTypeCompat.RESISTANCE.get()).getAmplifier() + 1;
                double resistanceReductionFactor = Math.min(1.0, (double)level * 0.2);
                double resistanceReduction = -resistanceReductionFactor * currentDamage;
                damageModifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceReduction);
                currentDamage += resistanceReduction;
            }
            if (currentDamage > 0.0 && damageModifiers.containsKey(EntityDamageEvent.DamageModifier.MAGIC)) {
                double enchantsReductionFactor = DefenceUtils.calculateArmourEnchantmentReductionFactor(damagedEntity.getEquipment().getArmorContents(), damageCause, randomness);
                double enchantsReduction = currentDamage * -enchantsReductionFactor;
                damageModifiers.put(EntityDamageEvent.DamageModifier.MAGIC, enchantsReduction);
                currentDamage += enchantsReduction;
            }
            if (damageModifiers.containsKey(EntityDamageEvent.DamageModifier.ABSORPTION)) {
                double absorptionAmount = getAbsorptionAmount.apply(damagedEntity);
                double absorptionReduction = -Math.min(absorptionAmount, currentDamage);
                damageModifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionReduction);
            }
        }
    }

    public static double getDamageAfterArmour1_8(LivingEntity defender, double baseDamage, ItemStack[] armourContents, EntityDamageEvent.DamageCause damageCause, boolean randomness) {
        double armourPoints = 0.0;
        for (int i = 0; i < armourContents.length; ++i) {
            ItemStack itemStack = armourContents[i];
            if (itemStack == null) continue;
            EquipmentSlot slot = (new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD})[i];
            armourPoints += DefenceUtils.getAttributeModifierSum(itemStack.getType().getDefaultAttributeModifiers(slot).get((Object)((Attribute)XAttribute.ARMOR.get())));
        }
        double reductionFactor = armourPoints * 0.04;
        double finalDamage = baseDamage - (ARMOUR_IGNORING_CAUSES.contains(damageCause) ? 0.0 : baseDamage * reductionFactor);
        if (defender.hasPotionEffect(PotionEffectTypeCompat.RESISTANCE.get())) {
            int resistanceLevel = defender.getPotionEffect(PotionEffectTypeCompat.RESISTANCE.get()).getAmplifier() + 1;
            finalDamage *= 1.0 - (double)resistanceLevel * 0.2;
        }
        double enchantmentReductionFactor = DefenceUtils.calculateArmourEnchantmentReductionFactor(armourContents, damageCause, randomness);
        if (finalDamage > 0.0) {
            finalDamage -= finalDamage * enchantmentReductionFactor;
        }
        Messenger.debug("Reductions: Armour %.0f%%, Ench %.0f%%, Total %.2f%%, Start dmg: %.2f Final: %.2f", reductionFactor * 100.0, enchantmentReductionFactor * 100.0, (reductionFactor + (1.0 - reductionFactor) * enchantmentReductionFactor) * 100.0, baseDamage, finalDamage);
        return finalDamage;
    }

    private static double getAttributeModifierSum(Collection<AttributeModifier> modifiers) {
        double sum = 0.0;
        for (AttributeModifier modifier : modifiers) {
            double value = modifier.getAmount();
            switch (modifier.getOperation()) {
                case ADD_SCALAR: {
                    sum += Math.abs(value);
                    break;
                }
                case ADD_NUMBER: {
                    sum += value;
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    sum *= value;
                }
            }
        }
        return sum;
    }

    private static double calculateArmourEnchantmentReductionFactor(ItemStack[] armourContents, EntityDamageEvent.DamageCause cause, boolean randomness) {
        int totalEpf = 0;
        for (ItemStack armourItem : armourContents) {
            if (armourItem == null || armourItem.getType() == Material.AIR) continue;
            for (EnchantmentType enchantmentType : EnchantmentType.values()) {
                int enchantmentLevel;
                if (!enchantmentType.protectsAgainst(cause) || (enchantmentLevel = armourItem.getEnchantmentLevel(enchantmentType.getEnchantment())) <= 0) continue;
                totalEpf += enchantmentType.getEpf(enchantmentLevel);
            }
        }
        totalEpf = Math.min(25, totalEpf);
        double multiplier = randomness ? ThreadLocalRandom.current().nextDouble(0.5, 1.0) : 1.0;
        totalEpf = (int)Math.ceil((double)totalEpf * multiplier);
        totalEpf = Math.min(20, totalEpf);
        return 0.04 * (double)totalEpf;
    }

    static {
        if (Reflector.versionIsNewerOrEqualTo(1, 11, 0)) {
            ARMOUR_IGNORING_CAUSES.add(EntityDamageEvent.DamageCause.CRAMMING);
        }
        if (Reflector.versionIsNewerOrEqualTo(1, 17, 0)) {
            ARMOUR_IGNORING_CAUSES.add(EntityDamageEvent.DamageCause.FREEZE);
        }
        getAbsorptionAmount = SpigotFunctionChooser.apiCompatCall((le, params) -> le.getAbsorptionAmount(), (le, params) -> VersionCompatUtils.getAbsorptionAmount(le));
    }

    private static enum EnchantmentType {
        PROTECTION(() -> {
            EnumSet<EntityDamageEvent.DamageCause[]> damageCauses = EnumSet.of(EntityDamageEvent.DamageCause.CONTACT, new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.ENTITY_ATTACK, EntityDamageEvent.DamageCause.PROJECTILE, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.LAVA, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.LIGHTNING, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.MAGIC, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.FALLING_BLOCK, EntityDamageEvent.DamageCause.THORNS, EntityDamageEvent.DamageCause.DRAGON_BREATH});
            if (Reflector.versionIsNewerOrEqualTo(1, 10, 0)) {
                damageCauses.add((EntityDamageEvent.DamageCause[])EntityDamageEvent.DamageCause.HOT_FLOOR);
            }
            if (Reflector.versionIsNewerOrEqualTo(1, 12, 0)) {
                damageCauses.add((EntityDamageEvent.DamageCause[])EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK);
            }
            return damageCauses;
        }, 0.75, EnchantmentCompat.PROTECTION.get()),
        FIRE_PROTECTION(() -> {
            EnumSet<EntityDamageEvent.DamageCause> damageCauses = EnumSet.of(EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.LAVA);
            if (Reflector.versionIsNewerOrEqualTo(1, 10, 0)) {
                damageCauses.add(EntityDamageEvent.DamageCause.HOT_FLOOR);
            }
            return damageCauses;
        }, 1.25, EnchantmentCompat.FIRE_PROTECTION.get()),
        BLAST_PROTECTION(() -> EnumSet.of(EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION), 1.5, EnchantmentCompat.BLAST_PROTECTION.get()),
        PROJECTILE_PROTECTION(() -> EnumSet.of(EntityDamageEvent.DamageCause.PROJECTILE), 1.5, EnchantmentCompat.PROJECTILE_PROTECTION.get()),
        FALL_PROTECTION(() -> EnumSet.of(EntityDamageEvent.DamageCause.FALL), 2.5, EnchantmentCompat.FEATHER_FALLING.get());

        private final Set<EntityDamageEvent.DamageCause> protection;
        private final double typeModifier;
        private final Enchantment enchantment;

        private EnchantmentType(Supplier<Set<EntityDamageEvent.DamageCause>> protection, double typeModifier, Enchantment enchantment) {
            this.protection = protection.get();
            this.typeModifier = typeModifier;
            this.enchantment = enchantment;
        }

        public boolean protectsAgainst(EntityDamageEvent.DamageCause cause) {
            return this.protection.contains(cause);
        }

        public Enchantment getEnchantment() {
            return this.enchantment;
        }

        public int getEpf(int level) {
            return (int)Math.floor((double)(6 + level * level) * this.typeModifier / 3.0);
        }
    }
}

