/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ModuleDisableOffHand
extends OCMModule {
    private static final int OFFHAND_SLOT = 40;
    private List<Material> materials;
    private String deniedMessage;
    private BlockType blockType;

    public ModuleDisableOffHand(OCMMain plugin) {
        super(plugin, "disable-offhand");
        this.reload();
    }

    @Override
    public void reload() {
        this.blockType = this.module().getBoolean("whitelist") ? BlockType.WHITELIST : BlockType.BLACKLIST;
        this.materials = ConfigUtils.loadMaterialList(this.module(), "items");
        this.deniedMessage = this.module().getString("denied-message");
    }

    private void sendDeniedMessage(CommandSender sender) {
        if (!this.deniedMessage.trim().isEmpty()) {
            Messenger.send(sender, this.deniedMessage, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSwapHandItems(PlayerSwapHandItemsEvent e) {
        Player player = e.getPlayer();
        if (this.isEnabled((HumanEntity)player) && this.isItemBlocked(e.getOffHandItem())) {
            e.setCancelled(true);
            this.sendDeniedMessage((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity player = e.getWhoClicked();
        if (!this.isEnabled(player)) {
            return;
        }
        ClickType clickType = e.getClick();
        try {
            if (clickType == ClickType.SWAP_OFFHAND) {
                e.setResult(Event.Result.DENY);
                this.sendDeniedMessage((CommandSender)player);
                return;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        Inventory clickedInventory = e.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        InventoryType inventoryType = clickedInventory.getType();
        if (inventoryType != InventoryType.PLAYER) {
            return;
        }
        try {
            Object view = Reflector.invokeMethod(Reflector.getMethod(e.getClass(), "getView"), e, new Object[0]);
            Inventory bottom = (Inventory)Reflector.invokeMethod(Reflector.getMethod(view.getClass(), "getBottomInventory"), view, new Object[0]);
            Inventory top = (Inventory)Reflector.invokeMethod(Reflector.getMethod(view.getClass(), "getTopInventory"), view, new Object[0]);
            if (bottom.getType() != InventoryType.CRAFTING && top.getType() != InventoryType.CRAFTING) {
                return;
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
        ItemStack currentItem = e.getCurrentItem();
        if (currentItem != null && currentItem.getType() == Material.SHIELD && this.isItemBlocked(currentItem) && e.getSlot() != 40 && e.isShiftClick()) {
            e.setResult(Event.Result.DENY);
            this.sendDeniedMessage((CommandSender)player);
        }
        if (e.getSlot() == 40 && (clickType == ClickType.NUMBER_KEY && this.isItemBlocked(clickedInventory.getItem(e.getHotbarButton())) || this.isItemBlocked(e.getCursor()))) {
            e.setResult(Event.Result.DENY);
            this.sendDeniedMessage((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent e) {
        HumanEntity player = e.getWhoClicked();
        if (!this.isEnabled(player) || e.getInventory().getType() != InventoryType.CRAFTING || !e.getInventorySlots().contains(40)) {
            return;
        }
        if (this.isItemBlocked(e.getOldCursor())) {
            e.setResult(Event.Result.DENY);
            this.sendDeniedMessage((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.onModesetChange(e.getPlayer());
    }

    @Override
    public void onModesetChange(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack offHandItem = inventory.getItemInOffHand();
        if (this.isItemBlocked(offHandItem)) {
            this.sendDeniedMessage((CommandSender)player);
            inventory.setItemInOffHand(new ItemStack(Material.AIR));
            if (!inventory.addItem(new ItemStack[]{offHandItem}).isEmpty()) {
                player.getWorld().dropItemNaturally(player.getLocation(), offHandItem);
            }
        }
    }

    private boolean isItemBlocked(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return !this.blockType.isAllowed(this.materials, item.getType());
    }

    private static <T, U> BiPredicate<T, U> not(BiPredicate<T, U> predicate) {
        return predicate.negate();
    }

    private static enum BlockType {
        WHITELIST(Collection::contains),
        BLACKLIST(ModuleDisableOffHand.not(Collection::contains));

        private final BiPredicate<Collection<Material>, Material> filter;

        private BlockType(BiPredicate<Collection<Material>, Material> filter) {
            this.filter = filter;
        }

        boolean isAllowed(Collection<Material> list, Material toCheck) {
            return this.filter.test(list, toCheck);
        }
    }
}

