/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.concurrent.ThreadLocalRandom;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.MathsHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ModuleChorusFruit
extends OCMModule {
    public ModuleChorusFruit(OCMMain plugin) {
        super(plugin, "chorus-fruit");
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent e) {
        if (e.getItem().getType() != Material.CHORUS_FRUIT) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        if (this.module().getBoolean("prevent-eating")) {
            e.setCancelled(true);
            return;
        }
        int hungerValue = this.module().getInt("hunger-value");
        double saturationValue = this.module().getDouble("saturation-value");
        int previousFoodLevel = player.getFoodLevel();
        float previousSaturation = player.getSaturation();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int newFoodLevel = Math.min(hungerValue + previousFoodLevel, 20);
            float newSaturation = Math.min((float)(saturationValue + (double)previousSaturation), (float)newFoodLevel);
            player.setFoodLevel(newFoodLevel);
            player.setSaturation(newSaturation);
            this.debug("Food level changed from: " + previousFoodLevel + " to " + player.getFoodLevel(), (CommandSender)player);
        }, 2L);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        double distance = this.getMaxTeleportationDistance();
        if (distance == 8.0) {
            this.debug("Using vanilla teleport implementation!", (CommandSender)player);
            return;
        }
        if (distance <= 0.0) {
            this.debug("Chorus teleportation is not allowed", (CommandSender)player);
            e.setCancelled(true);
            return;
        }
        Location toLocation = e.getTo();
        if (toLocation == null) {
            this.debug("Teleport target is null", (CommandSender)player);
            return;
        }
        int maxheight = toLocation.getWorld().getMaxHeight();
        e.setTo(player.getLocation().add(ThreadLocalRandom.current().nextDouble(-distance, distance), MathsHelper.clamp(ThreadLocalRandom.current().nextDouble(-distance, distance), 0.0, maxheight - 1), ThreadLocalRandom.current().nextDouble(-distance, distance)));
    }

    private double getMaxTeleportationDistance() {
        return this.module().getDouble("max-teleportation-distance");
    }
}

