/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionTypeCompat;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigUtils {
    public static Map<String, Double> loadDoubleMap(ConfigurationSection section) {
        Objects.requireNonNull(section, "section cannot be null!");
        return section.getKeys(false).stream().filter(((Predicate<String>)arg_0 -> ((ConfigurationSection)section).isDouble(arg_0)).or(arg_0 -> ((ConfigurationSection)section).isInt(arg_0))).collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)section).getDouble(arg_0)));
    }

    public static List<Material> loadMaterialList(ConfigurationSection section, String key) {
        Objects.requireNonNull(section, "section cannot be null!");
        Objects.requireNonNull(key, "key cannot be null!");
        if (!section.isList(key)) {
            return new ArrayList<Material>();
        }
        return section.getStringList(key).stream().map(Material::matchMaterial).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static HashMap<PotionTypeCompat, PotionDurations> loadPotionDurationsList(ConfigurationSection section) {
        Objects.requireNonNull(section, "potion durations section cannot be null!");
        HashMap<PotionTypeCompat, PotionDurations> durationsHashMap = new HashMap<PotionTypeCompat, PotionDurations>();
        ConfigurationSection durationsSection = section.getConfigurationSection("potion-durations");
        ConfigurationSection drinkableSection = durationsSection.getConfigurationSection("drinkable");
        ConfigurationSection splashSection = durationsSection.getConfigurationSection("splash");
        for (String newPotionTypeName : drinkableSection.getKeys(false)) {
            try {
                int drinkableDuration = drinkableSection.getInt(newPotionTypeName) * 20;
                int splashDuration = splashSection.getInt(newPotionTypeName) * 20;
                PotionTypeCompat potionTypeCompat = new PotionTypeCompat(newPotionTypeName);
                durationsHashMap.put(potionTypeCompat, new PotionDurations(drinkableDuration, splashDuration));
            }
            catch (IllegalArgumentException e) {
                Messenger.debug("Skipping loading " + newPotionTypeName + " potion", new Object[0]);
            }
        }
        return durationsHashMap;
    }
}

