/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.potions;

import java.util.Locale;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class PotionTypeCompat {
    private final String oldName;
    private final String newName;
    private final PotionType potionType;
    private final boolean isStrong;
    private final boolean isLong;

    public PotionType getType() {
        return this.potionType;
    }

    public boolean isStrong() {
        return this.isStrong;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public String getNewName() {
        return this.newName;
    }

    public int hashCode() {
        return this.newName.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PotionTypeCompat && this.newName.equals(((PotionTypeCompat)o).newName);
    }

    @Nullable
    private PotionType getPotionType() {
        PotionType potionType;
        try {
            potionType = PotionType.valueOf((String)this.newName);
        }
        catch (IllegalArgumentException e) {
            if (this.oldName.equals("UNCRAFTABLE")) {
                return null;
            }
            try {
                potionType = PotionType.valueOf((String)this.oldName);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException("Invalid potion type, tried " + this.newName + " and " + this.oldName, exception);
            }
        }
        return potionType;
    }

    public PotionTypeCompat(String newName) {
        String oldName;
        this.newName = newName.toUpperCase(Locale.ROOT);
        try {
            oldName = PotionTypeMapper.valueOf((String)newName).oldName;
        }
        catch (IllegalArgumentException e) {
            oldName = this.newName.replace("STRONG_", "").replace("LONG_", "");
        }
        this.oldName = oldName;
        this.potionType = this.getPotionType();
        this.isStrong = newName.startsWith("STRONG_");
        this.isLong = newName.startsWith("LONG_");
    }

    public PotionTypeCompat(String oldName, boolean isStrong, boolean isLong) {
        this.oldName = oldName.toUpperCase(Locale.ROOT);
        String newName = null;
        for (PotionTypeMapper mapped : PotionTypeMapper.values()) {
            String mappedName;
            if (!mapped.oldName.equals(this.oldName) || isStrong != (mappedName = mapped.name()).startsWith("STRONG_") || isLong != mappedName.startsWith("LONG_")) continue;
            newName = mappedName;
            break;
        }
        this.newName = newName == null ? (isStrong ? "STRONG_" + this.oldName : (isLong ? "LONG_" + this.oldName : this.oldName)) : newName;
        this.potionType = this.getPotionType();
        this.isStrong = isStrong;
        this.isLong = isLong;
    }

    public static PotionTypeCompat fromPotionMeta(PotionMeta potionMeta) {
        try {
            PotionType potionType = potionMeta.getBasePotionType();
            if (potionType == null) {
                return new PotionTypeCompat("UNCRAFTABLE");
            }
            return new PotionTypeCompat(potionType.name());
        }
        catch (NoSuchMethodError e) {
            PotionData potionData = potionMeta.getBasePotionData();
            PotionType potionType = potionData.getType();
            return new PotionTypeCompat(potionType.name(), potionData.isUpgraded(), potionData.isExtended());
        }
    }

    private static enum PotionTypeMapper {
        HARMING("INSTANT_DAMAGE"),
        STRONG_HARMING("INSTANT_DAMAGE"),
        HEALING("INSTANT_HEAL"),
        STRONG_HEALING("INSTANT_HEAL"),
        LEAPING("JUMP"),
        STRONG_LEAPING("JUMP"),
        LONG_LEAPING("JUMP"),
        REGENERATION("REGEN"),
        STRONG_REGENERATION("REGEN"),
        LONG_REGENERATION("REGEN"),
        SWIFTNESS("SPEED"),
        STRONG_SWIFTNESS("SPEED"),
        LONG_SWIFTNESS("SPEED");

        private final String oldName;

        private PotionTypeMapper(String oldName) {
            this.oldName = oldName;
        }
    }
}

