/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ModuleShieldDamageReduction
extends OCMModule {
    private int genericDamageReductionAmount;
    private int genericDamageReductionPercentage;
    private int projectileDamageReductionAmount;
    private int projectileDamageReductionPercentage;
    private final Map<UUID, List<ItemStack>> fullyBlocked = new WeakHashMap<UUID, List<ItemStack>>();

    public ModuleShieldDamageReduction(OCMMain plugin) {
        super(plugin, "shield-damage-reduction");
        this.reload();
    }

    @Override
    public void reload() {
        this.genericDamageReductionAmount = this.module().getInt("generalDamageReductionAmount", 1);
        this.genericDamageReductionPercentage = this.module().getInt("generalDamageReductionPercentage", 50);
        this.projectileDamageReductionAmount = this.module().getInt("projectileDamageReductionAmount", 1);
        this.projectileDamageReductionPercentage = this.module().getInt("projectileDamageReductionPercentage", 50);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        ItemStack item = e.getItem();
        if (this.fullyBlocked.containsKey(uuid)) {
            List<ItemStack> armour = this.fullyBlocked.get(uuid);
            List matchedPieces = armour.stream().filter(piece -> piece.equals((Object)item)).collect(Collectors.toList());
            armour.removeAll(matchedPieces);
            this.debug("Ignoring armour durability damage due to full block", (CommandSender)player);
            if (!matchedPieces.isEmpty()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isEnabled(e.getDamager(), (Entity)player)) {
            return;
        }
        double baseDamage = e.getDamage(EntityDamageEvent.DamageModifier.BASE) + e.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        if (!this.shieldBlockedDamage(baseDamage, e.getDamage(EntityDamageEvent.DamageModifier.BLOCKING))) {
            return;
        }
        double damageReduction = this.getDamageReduction(baseDamage, e.getCause());
        e.setDamage(EntityDamageEvent.DamageModifier.BLOCKING, -damageReduction);
        double currentDamage = baseDamage - damageReduction;
        this.debug("Blocking: " + baseDamage + " - " + damageReduction + " = " + currentDamage, (CommandSender)player);
        this.debug("Blocking: " + baseDamage + " - " + damageReduction + " = " + currentDamage);
        UUID uuid = player.getUniqueId();
        if (currentDamage <= 0.0) {
            List armour = Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).collect(Collectors.toList());
            this.fullyBlocked.put(uuid, armour);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.fullyBlocked.remove(uuid);
                this.debug("Removed from fully blocked set!", (CommandSender)player);
            }, 1L);
        }
    }

    private double getDamageReduction(double damage, EntityDamageEvent.DamageCause damageCause) {
        double reduction = damage - (double)(damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? this.projectileDamageReductionAmount : this.genericDamageReductionAmount);
        if ((reduction *= (double)(damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? this.projectileDamageReductionPercentage : this.genericDamageReductionPercentage) / 100.0) < 0.0) {
            reduction = 0.0;
        }
        return reduction;
    }

    private boolean shieldBlockedDamage(double attackDamage, double blockingReduction) {
        return attackDamage > 0.0 && blockingReduction < 0.0;
    }
}

