/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XEntityType;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ModuleFishingKnockback
extends OCMModule {
    private final SpigotFunctionChooser<PlayerFishEvent, Object, Entity> getHookFunction;
    private final SpigotFunctionChooser<ProjectileHitEvent, Object, Entity> getHitEntityFunction;
    private boolean knockbackNonPlayerEntities;

    public ModuleFishingKnockback(OCMMain plugin) {
        super(plugin, "old-fishing-knockback");
        this.reload();
        this.getHookFunction = SpigotFunctionChooser.apiCompatReflectionCall((e, params) -> e.getHook(), PlayerFishEvent.class, "getHook", new String[0]);
        this.getHitEntityFunction = SpigotFunctionChooser.apiCompatCall((e, params) -> e.getHitEntity(), (e, params) -> {
            Projectile hookEntity = e.getEntity();
            return hookEntity.getWorld().getNearbyEntities(hookEntity.getLocation(), 0.25, 0.25, 0.25).stream().filter(entity -> !this.knockbackNonPlayerEntities && entity instanceof Player).findFirst().orElse(null);
        });
    }

    @Override
    public void reload() {
        this.knockbackNonPlayerEntities = this.isSettingEnabled("knockbackNonPlayerEntities");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onRodLand(ProjectileHitEvent event) {
        Projectile hookEntity = event.getEntity();
        EntityType fishingBobberType = XEntityType.FISHING_BOBBER.get();
        if (fishingBobberType == null || event.getEntityType() != fishingBobberType) {
            return;
        }
        FishHook hook = (FishHook)hookEntity;
        ProjectileSource projectileSource = hook.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player rodder = (Player)projectileSource;
        if (!this.isEnabled((HumanEntity)rodder)) {
            return;
        }
        Entity hitEntity = this.getHitEntityFunction.apply(event);
        if (hitEntity == null) {
            return;
        }
        if (!(hitEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)hitEntity;
        if (!this.knockbackNonPlayerEntities && !(hitEntity instanceof Player)) {
            return;
        }
        if (hitEntity.hasMetadata("NPC")) {
            return;
        }
        if (!this.knockbackNonPlayerEntities) {
            Player player = (Player)hitEntity;
            this.debug("You were hit by a fishing rod!", (CommandSender)player);
            if (player.equals(rodder)) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
        }
        if ((float)livingEntity.getNoDamageTicks() > (float)livingEntity.getMaximumNoDamageTicks() / 2.0f) {
            return;
        }
        double damage = this.module().getDouble("damage");
        if (damage < 0.0) {
            damage = 1.0E-4;
        }
        livingEntity.damage(damage, (Entity)rodder);
        livingEntity.setVelocity(this.calculateKnockbackVelocity(livingEntity.getVelocity(), livingEntity.getLocation(), hook.getLocation()));
    }

    private Vector calculateKnockbackVelocity(Vector currentVelocity, Location player, Location hook) {
        double xDistance = hook.getX() - player.getX();
        double zDistance = hook.getZ() - player.getZ();
        while (xDistance * xDistance + zDistance * zDistance < 1.0E-4) {
            xDistance = (Math.random() - Math.random()) * 0.01;
            zDistance = (Math.random() - Math.random()) * 0.01;
        }
        double distance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        double y = currentVelocity.getY() / 2.0;
        double x = currentVelocity.getX() / 2.0;
        double z = currentVelocity.getZ() / 2.0;
        x -= xDistance / distance * 0.4;
        y += 0.4;
        z -= zDistance / distance * 0.4;
        if (y >= 0.4) {
            y = 0.4;
        }
        return new Vector(x, y, z);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onReelIn(PlayerFishEvent e) {
        if (e.getState() != PlayerFishEvent.State.CAUGHT_ENTITY) {
            return;
        }
        if (!this.isEnabled((HumanEntity)e.getPlayer())) {
            return;
        }
        String cancelDraggingIn = this.module().getString("cancelDraggingIn", "players");
        boolean isPlayer = e.getCaught() instanceof HumanEntity;
        if (cancelDraggingIn.equals("players") && isPlayer || cancelDraggingIn.equals("mobs") && !isPlayer || cancelDraggingIn.equals("all")) {
            this.getHookFunction.apply(e).remove();
            e.setCancelled(true);
        }
    }
}

