/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.projectiles.ProjectileSource;

public class ModuleDisableEnderpearlCooldown
extends OCMModule {
    private final Set<UUID> ignoredPlayers = new HashSet<UUID>();
    private Map<UUID, Long> lastLaunched;
    private int cooldown;
    private String message;
    private static ModuleDisableEnderpearlCooldown INSTANCE;

    public ModuleDisableEnderpearlCooldown(OCMMain plugin) {
        super(plugin, "disable-enderpearl-cooldown");
        INSTANCE = this;
        this.reload();
    }

    @Override
    public void reload() {
        this.cooldown = this.module().getInt("cooldown");
        if (this.cooldown > 0) {
            if (this.lastLaunched == null) {
                this.lastLaunched = new WeakHashMap<UUID, Long>();
            }
        } else {
            this.lastLaunched = null;
        }
        this.message = this.module().getBoolean("showMessage") ? this.module().getString("message") : null;
    }

    public static ModuleDisableEnderpearlCooldown getInstance() {
        return INSTANCE;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerShoot(ProjectileLaunchEvent e) {
        ItemStack enderpearlItemStack;
        if (e.isCancelled()) {
            return;
        }
        Projectile projectile = e.getEntity();
        if (!(projectile instanceof EnderPearl)) {
            return;
        }
        ProjectileSource shooter = projectile.getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.ignoredPlayers.contains(uuid)) {
            return;
        }
        e.setCancelled(true);
        if (this.lastLaunched != null) {
            long elapsedSeconds;
            long currentTime = System.currentTimeMillis() / 1000L;
            if (this.lastLaunched.containsKey(uuid) && (elapsedSeconds = currentTime - this.lastLaunched.get(uuid)) < (long)this.cooldown) {
                if (this.message != null) {
                    Messenger.send((CommandSender)player, this.message, (long)this.cooldown - elapsedSeconds);
                }
                return;
            }
            this.lastLaunched.put(uuid, currentTime);
        }
        this.ignoredPlayers.add(uuid);
        EnderPearl pearl = (EnderPearl)player.launchProjectile(EnderPearl.class);
        this.ignoredPlayers.remove(uuid);
        pearl.setVelocity(player.getEyeLocation().getDirection().multiply(2));
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        ItemStack mainHand = playerInventory.getItemInMainHand();
        ItemStack offHand = playerInventory.getItemInOffHand();
        if (this.isEnderPearl(mainHand)) {
            enderpearlItemStack = mainHand;
        } else if (this.isEnderPearl(offHand)) {
            enderpearlItemStack = offHand;
        } else {
            return;
        }
        enderpearlItemStack.setAmount(enderpearlItemStack.getAmount() - 1);
    }

    private boolean isEnderPearl(ItemStack itemStack) {
        return itemStack != null && itemStack.getType() == Material.ENDER_PEARL;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        if (this.lastLaunched != null) {
            this.lastLaunched.remove(e.getPlayer().getUniqueId());
        }
    }

    public long getEnderpearlCooldown(UUID playerUUID) {
        if (this.lastLaunched != null && this.lastLaunched.containsKey(playerUUID)) {
            long currentTime = System.currentTimeMillis() / 1000L;
            long lastLaunchTime = this.lastLaunched.get(playerUUID);
            long elapsedSeconds = currentTime - lastLaunchTime;
            long cooldownRemaining = (long)this.cooldown - elapsedSeconds;
            return Math.max(cooldownRemaining, 0L);
        }
        return 0L;
    }
}

