/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.versions.enchantments;

import java.util.Locale;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.Nullable;

public enum EnchantmentCompat {
    UNBREAKING("DURABILITY"),
    PROTECTION("PROTECTION_ENVIRONMENTAL"),
    FIRE_PROTECTION("PROTECTION_FIRE"),
    BLAST_PROTECTION("PROTECTION_EXPLOSIONS"),
    PROJECTILE_PROTECTION("PROTECTION_PROJECTILE"),
    FEATHER_FALLING("PROTECTION_FALL"),
    SMITE("DAMAGE_UNDEAD"),
    BANE_OF_ARTHROPODS("DAMAGE_ARTHROPODS"),
    SHARPNESS("DAMAGE_ALL");

    private final String oldName;
    private Enchantment enchantment;

    private EnchantmentCompat(String oldName) {
        this.oldName = oldName;
    }

    public synchronized Enchantment get() {
        if (this.enchantment != null) {
            return this.enchantment;
        }
        Enchantment found = Enchantment.getByName((String)this.name());
        if (found == null) {
            found = Enchantment.getByName((String)this.oldName);
        }
        if (found == null) {
            throw new IllegalStateException("Enchantment not found for: " + this.name() + " or " + this.oldName);
        }
        this.enchantment = found;
        return found;
    }

    @Nullable
    public static Enchantment fromNewName(String newName) {
        try {
            return EnchantmentCompat.valueOf(newName.toUpperCase(Locale.ROOT)).get();
        }
        catch (IllegalArgumentException e) {
            return Enchantment.getByName((String)newName);
        }
    }
}

