/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.storage;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerData;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerDataCodec;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PlayerStorage {
    private static OCMMain plugin;
    private static Path dataFilePath;
    private static DocumentCodec documentCodec;
    private static Document data;
    private static final AtomicReference<BukkitTask> saveTask;
    private static CodecRegistry codecRegistry;

    public static void initialise(OCMMain plugin) {
        PlayerStorage.plugin = plugin;
        dataFilePath = Paths.get(String.valueOf(plugin.getDataFolder()) + File.separator + "players.bson", new String[0]);
        codecRegistry = CodecRegistries.fromRegistries(CodecRegistries.fromCodecs(new DocumentCodec()), CodecRegistries.fromCodecs(new PlayerDataCodec()), CodecRegistries.fromProviders(new BsonValueCodecProvider(), new ValueCodecProvider()));
        documentCodec = new DocumentCodec(codecRegistry);
        data = PlayerStorage.loadData();
        saveTask.set(null);
    }

    private static Document loadData() {
        if (Files.notExists(dataFilePath, new LinkOption[0])) {
            return new Document();
        }
        try {
            byte[] data = Files.readAllBytes(dataFilePath);
            BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(data));
            return documentCodec.decode(reader, DecoderContext.builder().build());
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Error loading player data", e);
            return new Document();
        }
    }

    public static void scheduleSave() {
        saveTask.compareAndSet(null, Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> {
            PlayerStorage.instantSave();
            saveTask.set(null);
        }, 2400L));
    }

    public static void instantSave() {
        BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter(outputBuffer);
        documentCodec.encode((BsonWriter)writer, data, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        writer.flush();
        try {
            Files.write(dataFilePath, outputBuffer.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Error saving player data", e);
        }
        finally {
            outputBuffer.close();
        }
    }

    public static PlayerData getPlayerData(UUID uuid) {
        Document playerDoc = (Document)data.get(uuid.toString());
        if (playerDoc == null) {
            PlayerData playerData = new PlayerData();
            PlayerStorage.setPlayerData(uuid, playerData);
            PlayerStorage.scheduleSave();
            return playerData;
        }
        BsonDocumentWrapper<Document> bsonDocument = new BsonDocumentWrapper<Document>(playerDoc, documentCodec);
        return (PlayerData)codecRegistry.get(PlayerData.class).decode(bsonDocument.asBsonReader(), DecoderContext.builder().build());
    }

    public static void setPlayerData(UUID uuid, PlayerData playerData) {
        BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
        PlayerDataCodec playerDataCodec = (PlayerDataCodec)codecRegistry.get(PlayerData.class);
        playerDataCodec.encode((BsonWriter)writer, playerData, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        BsonDocument bsonDocument = writer.getDocument();
        Document document = new Document();
        bsonDocument.forEach((key, value) -> document.put((String)key, value.isDocument() ? new Document(value.asDocument()) : value));
        data.put(uuid.toString(), (Object)document);
    }

    static {
        saveTask = new AtomicReference();
    }
}

