/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.potions;

import java.util.Locale;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public enum PotionEffectTypeCompat {
    RESISTANCE("DAMAGE_RESISTANCE"),
    NAUSEA("CONFUSION"),
    HASTE("FAST_DIGGING"),
    INSTANT_DAMAGE("HARM"),
    INSTANT_HEALTH("HEAL"),
    STRENGTH("INCREASE_DAMAGE"),
    JUMP_BOOST("JUMP"),
    SLOWNESS("SLOW"),
    MINING_FATIGUE("SLOW_DIGGING");

    private PotionEffectType potionEffectType = PotionEffectType.getByName((String)this.name());

    private PotionEffectTypeCompat(String oldName) {
        if (this.potionEffectType == null) {
            this.potionEffectType = PotionEffectType.getByName((String)oldName);
        }
        if (this.potionEffectType == null) {
            throw new IllegalStateException("PotionEffectType not found for: " + this.name() + " or " + oldName);
        }
    }

    public PotionEffectType get() {
        return this.potionEffectType;
    }

    @Nullable
    public static PotionEffectType fromNewName(String newName) {
        try {
            return PotionEffectTypeCompat.valueOf(newName.toUpperCase(Locale.ROOT)).get();
        }
        catch (IllegalArgumentException e) {
            return PotionEffectType.getByName((String)newName);
        }
    }
}

