/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EntityDamageByEntityListener
extends OCMModule {
    private static EntityDamageByEntityListener INSTANCE;
    private boolean enabled;
    private final Map<UUID, Double> lastDamages;

    public EntityDamageByEntityListener(OCMMain plugin) {
        super(plugin, "entity-damage-listener");
        INSTANCE = this;
        this.lastDamages = new WeakHashMap<UUID, Double>();
    }

    public static EntityDamageByEntityListener getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity damagee = event.getEntity();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            if (!(damagee instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingDamagee = (LivingEntity)damagee;
            this.restoreLastDamage(livingDamagee);
            double newDamage = event.getDamage();
            this.checkOverdamage(livingDamagee, event, newDamage);
            if (newDamage < 0.0) {
                this.debug("Damage was " + newDamage + " setting to 0");
                newDamage = 0.0;
            }
            event.setDamage(newDamage);
            this.debug("Attack damage (before defence): " + newDamage);
        } else {
            Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
            OCMEntityDamageByEntityEvent e = new OCMEntityDamageByEntityEvent(damager, damagee, event.getCause(), event.getDamage());
            if (damagee instanceof LivingEntity) {
                this.restoreLastDamage((LivingEntity)damagee);
            }
            this.plugin.getServer().getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            double newDamage = e.getBaseDamage();
            this.debug("Base: " + e.getBaseDamage(), (CommandSender)damager);
            this.debug("Base: " + e.getBaseDamage());
            double weaknessModifier = e.getWeaknessModifier() * (double)e.getWeaknessLevel();
            double weaknessAddend = e.isWeaknessModifierMultiplier() ? newDamage * weaknessModifier : weaknessModifier;
            this.debug("Weak: " + weaknessAddend);
            this.debug("Weak: " + weaknessAddend, (CommandSender)damager);
            this.debug("Strength level: " + e.getStrengthLevel());
            this.debug("Strength level: " + e.getStrengthLevel(), (CommandSender)damager);
            double strengthModifier = e.getStrengthModifier() * (double)e.getStrengthLevel();
            newDamage = !e.isStrengthModifierMultiplier() ? (newDamage += strengthModifier) : (e.isStrengthModifierAddend() ? (newDamage *= (strengthModifier += 1.0)) : (newDamage *= strengthModifier));
            this.debug("Strength: " + strengthModifier);
            this.debug("Strength: " + strengthModifier, (CommandSender)damager);
            newDamage += weaknessAddend;
            if (damager instanceof HumanEntity) {
                float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
                this.debug("Scale by attack delay: " + newDamage + " *= 0.2 + " + cooldown + "^2 * 0.8");
                newDamage *= (double)(0.2f + cooldown * cooldown * 0.8f);
            }
            double criticalMultiplier = e.getCriticalMultiplier();
            this.debug("Crit " + newDamage + " *= " + criticalMultiplier);
            newDamage *= criticalMultiplier;
            double enchantmentDamage = e.getMobEnchantmentsDamage() + e.getSharpnessDamage();
            if (damager instanceof HumanEntity) {
                float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
                this.debug("Scale enchantments by attack delay: " + enchantmentDamage + " *= " + cooldown);
                enchantmentDamage *= (double)cooldown;
            }
            newDamage += enchantmentDamage;
            this.debug("Mob " + e.getMobEnchantmentsDamage() + " Sharp: " + e.getSharpnessDamage() + " Scaled: " + enchantmentDamage, (CommandSender)damager);
            if (damagee instanceof LivingEntity) {
                newDamage = this.checkOverdamage((LivingEntity)damagee, event, newDamage);
            }
            if (newDamage < 0.0) {
                this.debug("Damage was " + newDamage + " setting to 0", (CommandSender)damager);
                newDamage = 0.0;
            }
            event.setDamage(newDamage);
            this.debug("New Damage: " + newDamage, (CommandSender)damager);
            this.debug("Attack damage (before defence): " + newDamage);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterEntityDamage(EntityDamageEvent event) {
        Entity damagee = event.getEntity();
        if (event instanceof EntityDamageByEntityEvent) {
            if (this.lastDamages.containsKey(damagee.getUniqueId())) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    ((LivingEntity)damagee).setLastDamage(0.0);
                    this.debug("Set last damage to 0", (CommandSender)damagee);
                    this.debug("Set last damage to 0");
                }, 1L);
            }
        } else {
            this.lastDamages.remove(damagee.getUniqueId());
            this.debug("Non-entity damage, using default last damage", (CommandSender)damagee);
            this.debug("Non-entity damage, using default last damage");
        }
    }

    private void restoreLastDamage(LivingEntity damagee) {
        Double lastStoredDamage = this.lastDamages.get(damagee.getUniqueId());
        if (lastStoredDamage != null) {
            LivingEntity livingDamagee = damagee;
            livingDamagee.setLastDamage(lastStoredDamage.doubleValue());
            this.debug("Set last damage back to " + lastStoredDamage, (CommandSender)livingDamagee);
            this.debug("Set last damage back to " + lastStoredDamage);
        }
    }

    private double checkOverdamage(LivingEntity livingDamagee, EntityDamageEvent event, double newDamage) {
        double newLastDamage = newDamage;
        if ((float)livingDamagee.getNoDamageTicks() > (float)livingDamagee.getMaximumNoDamageTicks() / 2.0f) {
            double lastDamage = livingDamagee.getLastDamage();
            if (newDamage <= lastDamage) {
                event.setDamage(0.0);
                event.setCancelled(true);
                this.debug("Was fake overdamage, cancelling " + newDamage + " <= " + lastDamage);
                return 0.0;
            }
            this.debug("Overdamage: " + newDamage + " - " + lastDamage);
            this.debug("Last damage " + lastDamage + " new damage: " + newLastDamage + " applied: " + (newDamage -= livingDamagee.getLastDamage()) + " ticks: " + livingDamagee.getNoDamageTicks() + " /" + livingDamagee.getMaximumNoDamageTicks());
        }
        this.lastDamages.put(livingDamagee.getUniqueId(), newLastDamage);
        return newDamage;
    }
}

