/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DefenceUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class ModuleOldArmourStrength
extends OCMModule {
    private boolean randomness;

    public ModuleOldArmourStrength(OCMMain plugin) {
        super(plugin, "old-armour-strength");
        this.reload();
    }

    @Override
    public void reload() {
        this.randomness = this.module().getBoolean("randomness");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent e) {
        Entity damager;
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity damagedEntity = (LivingEntity)e.getEntity();
        if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && e instanceof EntityDamageByEntityEvent && !this.isEnabled(damager = ((EntityDamageByEntityEvent)e).getDamager(), (Entity)damagedEntity)) {
            return;
        }
        Map<EntityDamageEvent.DamageModifier, Double> damageModifiers = Arrays.stream(EntityDamageEvent.DamageModifier.values()).filter(arg_0 -> ((EntityDamageEvent)e).isApplicable(arg_0)).collect(Collectors.toMap(m -> m, arg_0 -> ((EntityDamageEvent)e).getDamage(arg_0)));
        DefenceUtils.calculateDefenceDamageReduction(damagedEntity, damageModifiers, e.getCause(), this.randomness);
        damageModifiers.forEach((arg_0, arg_1) -> ((EntityDamageEvent)e).setDamage(arg_0, arg_1));
        this.debug("BASE: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.BASE)));
        this.debug("BLOCKING: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.BLOCKING)));
        this.debug("ARMOUR: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.ARMOR)));
        this.debug("RESISTANCE: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.RESISTANCE)));
        this.debug("ARMOUR ENCHS: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.MAGIC)));
        this.debug("ABSORPTION: " + String.valueOf(damageModifiers.get(EntityDamageEvent.DamageModifier.ABSORPTION)));
        double finalDamage = damageModifiers.values().stream().reduce(0.0, Double::sum);
        this.debug("Final damage after defence calc: " + finalDamage);
    }
}

