/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.hooks;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.hooks.api.Hook;
import kernitus.plugin.OldCombatMechanics.module.ModuleDisableEnderpearlCooldown;
import kernitus.plugin.OldCombatMechanics.module.ModuleGoldenApple;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerData;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerStorage;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIHook
implements Hook {
    private PlaceholderExpansion expansion;

    @Override
    public void init(final OCMMain plugin) {
        this.expansion = new PlaceholderExpansion(){

            public boolean canRegister() {
                return true;
            }

            public boolean persist() {
                return true;
            }

            @NotNull
            public String getIdentifier() {
                return "ocm";
            }

            @NotNull
            public String getAuthor() {
                return String.join((CharSequence)", ", plugin.getDescription().getAuthors());
            }

            @NotNull
            public String getVersion() {
                return plugin.getDescription().getVersion();
            }

            public String onPlaceholderRequest(Player player, @NotNull String identifier) {
                if (player == null) {
                    return null;
                }
                switch (identifier) {
                    case "modeset": {
                        return this.getModeset(player);
                    }
                    case "gapple_cooldown": {
                        return this.getGappleCooldown(player);
                    }
                    case "napple_cooldown": {
                        return this.getNappleCooldown(player);
                    }
                    case "enderpearl_cooldown": {
                        return this.getEnderpearlCooldown(player);
                    }
                }
                return null;
            }

            private String getGappleCooldown(Player player) {
                long seconds = ModuleGoldenApple.getInstance().getGappleCooldown(player.getUniqueId());
                return seconds > 0L ? String.valueOf(seconds) : "None";
            }

            private String getNappleCooldown(Player player) {
                long seconds = ModuleGoldenApple.getInstance().getNappleCooldown(player.getUniqueId());
                return seconds > 0L ? String.valueOf(seconds) : "None";
            }

            private String getEnderpearlCooldown(Player player) {
                long seconds = ModuleDisableEnderpearlCooldown.getInstance().getEnderpearlCooldown(player.getUniqueId());
                return seconds > 0L ? String.valueOf(seconds) : "None";
            }

            private String getModeset(Player player) {
                PlayerData playerData = PlayerStorage.getPlayerData(player.getUniqueId());
                String modeName = playerData.getModesetForWorld(player.getWorld().getUID());
                if (modeName == null || modeName.isEmpty()) {
                    modeName = "unknown";
                }
                return modeName;
            }
        };
        this.expansion.register();
    }

    @Override
    public void deinit(OCMMain plugin) {
        if (this.expansion != null) {
            this.expansion.unregister();
        }
    }
}

