/*
 * Decompiled with CFR 0.152.
 */
package dev.kcbleeker.puffstatusplugin;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PuffStatusPlugin
extends JavaPlugin
implements Listener,
TabCompleter {
    private YamlConfiguration statusesConfig;
    private File statusesFile;

    public void onEnable() {
        this.getLogger().info("PuffStatusPlugin has been enabled!");
        this.statusesFile = new File(this.getDataFolder(), "statuses.yml");
        if (!this.statusesFile.exists()) {
            this.statusesFile.getParentFile().mkdirs();
            this.saveResource("statuses.yml", false);
        }
        this.statusesConfig = YamlConfiguration.loadConfiguration((File)this.statusesFile);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("status").setExecutor((CommandExecutor)this);
        this.getCommand("status").setTabCompleter((TabCompleter)this);
    }

    public void onDisable() {
        this.getLogger().info("PuffStatusPlugin has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String status = this.getStatus(player.getUniqueId());
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Component nameComponent = status != null && !status.isEmpty() ? miniMessage.deserialize((Object)status).append((Component)Component.space()).append(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)player.getName()).color(TextColor.color((int)0xFFFFFF))).decoration(TextDecoration.BOLD, false)).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.UNDERLINED, false)).decoration(TextDecoration.STRIKETHROUGH, false)).decoration(TextDecoration.OBFUSCATED, false)) : Component.text((String)player.getName()).color(TextColor.color((int)0xFFFFFF));
        player.displayName(nameComponent);
        player.playerListName(nameComponent);
    }

    public String getStatus(UUID uuid) {
        return this.statusesConfig.getString(uuid.toString());
    }

    public void setStatus(UUID uuid, String status) {
        this.statusesConfig.set(uuid.toString(), (Object)status);
        try {
            this.statusesConfig.save(this.statusesFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Could not save statuses.yml: " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can set their status.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage((Component)Component.text((String)"Usage: /status <your status message> or /status clear", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
            this.setStatus(player.getUniqueId(), null);
            Component nameComponent = Component.text((String)player.getName()).color(TextColor.color((int)0xFFFFFF));
            player.displayName(nameComponent);
            player.playerListName(nameComponent);
            player.sendMessage((Component)Component.text((String)"Your status has been cleared.", (TextColor)NamedTextColor.GREEN));
            return true;
        }
        String status = String.join((CharSequence)" ", args);
        this.setStatus(player.getUniqueId(), status);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Component nameComponent = miniMessage.deserialize((Object)status).append((Component)Component.space()).append(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)player.getName()).color(TextColor.color((int)0xFFFFFF))).decoration(TextDecoration.BOLD, false)).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.UNDERLINED, false)).decoration(TextDecoration.STRIKETHROUGH, false)).decoration(TextDecoration.OBFUSCATED, false));
        player.displayName(nameComponent);
        player.playerListName(nameComponent);
        player.sendMessage((Component)Component.text((String)("Your status has been set to: " + status), (TextColor)NamedTextColor.GREEN));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

