/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.api.CoordinateOffset;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record FixedOffset(int x, int z) implements Offset
{
    public FixedOffset {
        if (x % 16 != 0) {
            throw new IllegalArgumentException("Offset x=" + x + " is not chunk-aligned! (must be a multiple of 16)");
        }
        if (z % 16 != 0) {
            throw new IllegalArgumentException("Offset z=" + z + " is not chunk-aligned! (must be a multiple of 16)");
        }
    }

    @Override
    public String toString() {
        return "[x=" + this.x + ", z=" + this.z + "]";
    }

    @Override
    public FixedOffset negate() {
        return new FixedOffset(-this.x, -this.z);
    }

    @Override
    public boolean isZero() {
        return this.x == 0 && this.z == 0;
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    @Override
    public <T> T apply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation applied = l.apply(this);
        if (location instanceof OffsetLocation) {
            return (T)applied;
        }
        return (T)applied.getPlatformLocationObject();
    }

    @Override
    public <T> T unapply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation unapplied = l.unapply(this);
        if (location instanceof OffsetLocation) {
            return (T)unapplied;
        }
        return (T)unapplied.getPlatformLocationObject();
    }
}

