/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.OffsetHolder;
import com.jtprince.coordinateoffset.OffsetProviderClassRegistry;
import com.jtprince.coordinateoffset.adapter.CoordinateOffsetAdapter;
import com.jtprince.coordinateoffset.api.CoordinateOffsetAPIImpl;
import com.jtprince.coordinateoffset.command.OffsetCommandExecutor;
import com.jtprince.coordinateoffset.config.ConfigHolder;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfig;
import com.jtprince.coordinateoffset.config.CoordinateOffsetProviderConfig;
import com.jtprince.coordinateoffset.config.MessagesConfig;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.PermissionOffsetProvider;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CoordinateOffsetCore {
    private static @Nullable CoordinateOffsetCore singleton = null;
    private final CoordinateOffsetAdapter adapter;
    private final ConfigHolder configHolder;
    private final OffsetProviderClassRegistry providerClassRegistry;
    private final OffsetHolder offsetHolder;
    private final OffsetCommandExecutor commandExecutor;
    private final boolean isDebugEnabled = System.getProperty("coordinateoffset.debug", "false").equalsIgnoreCase("true");
    private boolean completedLoading = false;

    private CoordinateOffsetCore(CoordinateOffsetAdapter adapter) {
        this.adapter = adapter;
        this.configHolder = new ConfigHolder(this);
        this.providerClassRegistry = new OffsetProviderClassRegistry();
        this.offsetHolder = new OffsetHolder(this);
        this.commandExecutor = new OffsetCommandExecutor(this);
    }

    public static CoordinateOffsetCore bootstrap(CoordinateOffsetAdapter adapter) {
        CoordinateOffsetCore core;
        if (singleton != null) {
            throw new IllegalStateException("CoordinateOffset core is already initialized.");
        }
        singleton = core = new CoordinateOffsetCore(adapter);
        core.configHolder.loadMessagesConfig();
        core.configHolder.loadBaseConfig();
        CoordinateOffsetAPIImpl api = new CoordinateOffsetAPIImpl(core);
        CoordinateOffsetAPIImpl.set(api);
        core.getProviderRegistry().registerProviderClass("ConstantOffsetProvider", true, ConstantOffsetProvider::deserialize);
        core.getProviderRegistry().registerProviderClass("RandomOffsetProvider", true, RandomOffsetProvider::deserialize);
        core.getProviderRegistry().registerProviderClass("ZeroAtLocationOffsetProvider", true, ZeroAtLocationOffsetProvider::deserialize);
        core.getProviderRegistry().registerProviderClass("PermissionOffsetProvider", true, PermissionOffsetProvider::deserialize);
        return core;
    }

    public static CoordinateOffsetCore bootstrapForTests(CoordinateOffsetAdapter adapter) {
        CoordinateOffsetCore core = new CoordinateOffsetCore(adapter);
        CoordinateOffsetAPIImpl.set(new CoordinateOffsetAPIImpl(core));
        return core;
    }

    public boolean areAllProvidersLoaded() {
        return this.completedLoading;
    }

    public void signalCompletedLoading() {
        if (this.completedLoading) {
            return;
        }
        this.completedLoading = true;
        if (!this.configHolder.loadFullConfig()) {
            this.adapter.shutdown();
        }
    }

    public CoordinateOffsetAdapter getAdapter() {
        return this.adapter;
    }

    public OffsetProviderClassRegistry getProviderRegistry() {
        return this.providerClassRegistry;
    }

    public CoordinateOffsetConfig getConfig() {
        return this.configHolder.getConfig();
    }

    public CoordinateOffsetProviderConfig getProviderConfig() {
        return this.configHolder.getProviderConfig();
    }

    public MessagesConfig getMessages() {
        return this.configHolder.getMessagesConfig();
    }

    public OffsetCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public boolean reloadConfig() {
        return this.configHolder.reload();
    }

    public Logger getLogger() {
        return this.adapter.getLogger();
    }

    public OffsetHolder getOffsetHolder() {
        return this.offsetHolder;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public static CoordinateOffsetCore get() {
        if (singleton == null) {
            throw new IllegalStateException("CoordinateOffset core is not yet initialized.");
        }
        return singleton;
    }
}

