/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetWorld;
import com.jtprince.coordinateoffset.paper.adapter.PaperWorld;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperLocation
implements OffsetLocation {
    private final Location location;

    public PaperLocation(Location location) {
        this.location = location;
    }

    @Override
    public @Nullable OffsetWorld getWorld() {
        if (this.location.getWorld() == null) {
            return null;
        }
        return new PaperWorld(this.location.getWorld().getUID());
    }

    @Override
    public double getX() {
        return this.location.getX();
    }

    @Override
    public double getY() {
        return this.location.getY();
    }

    @Override
    public double getZ() {
        return this.location.getZ();
    }

    @Override
    public OffsetLocation apply(FixedOffset offset) {
        return new PaperLocation(this.location.clone().subtract((double)offset.x(), 0.0, (double)offset.z()));
    }

    @Override
    public OffsetLocation unapply(FixedOffset offset) {
        return new PaperLocation(this.location.clone().add((double)offset.x(), 0.0, (double)offset.z()));
    }

    public Location getPlatformLocationObject() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperLocation)) return false;
        PaperLocation p = (PaperLocation)obj;
        if (!this.location.equals((Object)p.location)) return false;
        return true;
    }
}

