/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.wrapper;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerNamedSoundEffect
extends PacketWrapper<WrapperPlayServerNamedSoundEffect> {
    private ResourceLocation soundName;
    private SoundCategory soundCategory;
    private Vector3i effectPosition;
    private byte[] remainingData;

    public WrapperPlayServerNamedSoundEffect(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerNamedSoundEffect(ResourceLocation soundName, SoundCategory soundCategory, Vector3i effectPosition, byte[] remainingData) {
        super((PacketTypeCommon)PacketType.Play.Server.NAMED_SOUND_EFFECT);
        this.soundName = soundName;
        this.soundCategory = soundCategory;
        this.effectPosition = effectPosition;
        this.remainingData = remainingData;
    }

    public void read() {
        this.soundName = this.readIdentifier();
        this.soundCategory = SoundCategory.fromId((int)this.readVarInt());
        this.effectPosition = new Vector3i(this.readInt(), this.readInt(), this.readInt());
        this.remainingData = this.readRemainingBytes();
    }

    public void write() {
        this.writeIdentifier(this.soundName);
        this.writeVarInt(this.soundCategory.ordinal());
        this.writeInt(this.effectPosition.x);
        this.writeInt(this.effectPosition.y);
        this.writeInt(this.effectPosition.z);
        this.writeBytes(this.remainingData);
    }

    public Vector3i getEffectPosition() {
        return this.effectPosition;
    }

    public void setEffectPosition(Vector3i effectPosition) {
        this.effectPosition = effectPosition;
    }
}

