/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.plugin;

import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.lib.io.netty.buffer.ByteBuf;
import com.jtprince.coordinateoffset.lib.io.netty.buffer.Unpooled;
import com.jtprince.coordinateoffset.offsetter.plugin.OffsetterPluginMessage;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PluginOffsetterDistantHorizons
implements OffsetterPluginMessage.PluginOffsetter {
    private static final String CHANNEL = "distant_horizons:message";
    private static final Set<String> CHANNELS = Set.of("distant_horizons:message");
    private static final short SUPPORTED_PROTOCOL_VERSION_MIN = 11;
    private static final short SUPPORTED_PROTOCOL_VERSION_MAX = 13;
    private static final int DH_MSG_ID_CONFIG = 3;
    private static final int DH_MSG_ID_EXCEPTION_MSG = 5;
    private static final int DH_MSG_ID_FULL_DATA_SOURCE_REQUEST = 6;
    private static final int DH_MSG_ID_FULL_DATA_SOURCE_RESPONSE = 7;
    private static final int DH_MSG_ID_FULL_DATA_PARTIAL_UPDATE = 8;
    private static final int DH_MSG_ID_FULL_DATA_CHUNK = 9;
    private static final int DH_MSG_EXCEPTION_REQUEST_REJECTED = 2;
    private static final int DH_MSG_EXCEPTION_SECTION_REQUIRES_SPLITTING = 3;
    private final ConcurrentHashMap<UUID, PlayerWarningCache> playerWarningCache = new ConcurrentHashMap();

    @Override
    public Set<String> getHandledChannels() {
        return CHANNELS;
    }

    @Override
    public OffsetterPluginMessage.PluginOffsetter.Server getServerOffsetter() {
        return new Server();
    }

    @Override
    public OffsetterPluginMessage.PluginOffsetter.Client getClientOffsetter() {
        return new Client();
    }

    @Override
    public void onUserDisconnect(User user) {
        this.playerWarningCache.remove(user.getUUID());
    }

    static void printConfig(ByteBuf data, boolean isIncoming) {
        boolean distantGenerationEnabled = data.readBoolean();
        int renderDistance = data.readInt();
        int borderCenterX = data.readInt();
        int borderCenterZ = data.readInt();
        int borderRadius = data.readInt();
        int fullDataRequestConcurrencyLimit = data.readInt();
        boolean realTimeUpdatesEnabled = data.readBoolean();
        int realTimeUpdateRadius = data.readInt();
        boolean loginDataSyncEnabled = data.readBoolean();
        int loginDataSyncRadius = data.readInt();
        int loginDataSyncRcLimit = data.readInt();
        int maxDataTransferSpeed = data.readInt();
        CoordinateOffsetCore.get().getLogger().info(String.format((isIncoming ? "Incoming" : "Outgoing") + " config message from Distant Horizons: distantGenerationEnabled=%b, renderDistance=%d, borderCenterX=%d, borderCenterZ=%d, borderRadius=%d, fullDataRequestConcurrencyLimit=%d, realTimeUpdatesEnabled=%b, realTimeUpdateRadius=%d, loginDataSyncEnabled=%b, loginDataSyncRadius=%d, loginDataSyncRcLimit=%d, maxDataTransferSpeed=%d", distantGenerationEnabled, renderDistance, borderCenterX, borderCenterZ, borderRadius, fullDataRequestConcurrencyLimit, realTimeUpdatesEnabled, realTimeUpdateRadius, loginDataSyncEnabled, loginDataSyncRadius, loginDataSyncRcLimit, maxDataTransferSpeed));
    }

    public class Server
    extends OffsetterPluginMessage.PluginOffsetter.Server {
        @Override
        public void offset(WrapperPlayServerPluginMessage packet, FixedOffset offset, User user) {
            int z;
            ByteBuf data = Unpooled.wrappedBuffer(packet.getData());
            short protocolVersion = data.readShort();
            short messageTypeId = data.readShort();
            if (protocolVersion < 11 || protocolVersion > 13) {
                if (offset.isZero()) {
                    return;
                }
                PlayerWarningCache warningCache = PluginOffsetterDistantHorizons.this.playerWarningCache.computeIfAbsent(user.getUUID(), k -> new PlayerWarningCache());
                if (!warningCache.hasWarnedProtocolVersion) {
                    warningCache.hasWarnedProtocolVersion = true;
                    CoordinateOffsetCore.get().getLogger().warning("A version of the Distant Horizons Support plugin (DHSupport) is installed which is not compatible with this version of CoordinateOffset. Player " + user.getName() + " may experience issues receiving LODs from the server while they have an offset applied. " + (protocolVersion < 11 ? "Update DHSupport to resolve this issue." : "Please update CoordinateOffset, or inform the CoordinateOffset developer of this issue if you are already on the latest version.") + " (DHS protocol version = " + protocolVersion + ", CoordinateOffset supported versions = 11-13)");
                }
            }
            if (messageTypeId == 3) {
                int borderRadius;
                int borderCenterZ;
                int borderCenterX;
                boolean distantGenerationEnabled = data.readBoolean();
                int renderDistance = data.readInt();
                if (CoordinateOffsetCore.get().getConfig().getObfuscateWorldBorder()) {
                    data.setInt(data.readerIndex(), 0);
                    borderCenterX = data.readInt();
                    data.setInt(data.readerIndex(), 0);
                    borderCenterZ = data.readInt();
                    data.setInt(data.readerIndex(), 30000000);
                    borderRadius = data.readInt();
                } else {
                    borderCenterX = data.getInt(data.readerIndex());
                    data.setInt(data.readerIndex(), borderCenterX - offset.x());
                    borderCenterX = data.readInt();
                    borderCenterZ = data.getInt(data.readerIndex());
                    data.setInt(data.readerIndex(), borderCenterZ - offset.z());
                    borderCenterZ = data.readInt();
                    borderRadius = data.readInt();
                }
                if (CoordinateOffsetCore.get().isDebugEnabled()) {
                    CoordinateOffsetCore.get().getLogger().info(String.format("Outgoing Distant Horizons config message: distantGenerationEnabled=%b, renderDistance=%d, borderCenterX=%d, borderCenterZ=%d, borderRadius=%d", distantGenerationEnabled, renderDistance, borderCenterX, borderCenterZ, borderRadius));
                }
            }
            if (messageTypeId == 5) {
                int tracker = data.readInt();
                int typeId = data.readInt();
                short messageLen = data.readShort();
                String exceptionMessage = data.readCharSequence(messageLen, StandardCharsets.UTF_8).toString();
                exceptionMessage.getBytes();
            }
            if (messageTypeId == 7) {
                int tracker = data.readInt();
                boolean hasBufferId = data.readBoolean();
                if (hasBufferId) {
                    int bufferId = data.readInt();
                    int numBeacons = data.readInt();
                    for (int i = 0; i < numBeacons; ++i) {
                        int x = data.readInt();
                        data.setInt(data.readerIndex() - 4, x - offset.x());
                        int y = data.readInt();
                        z = data.readInt();
                        data.setInt(data.readerIndex() - 4, z - offset.z());
                        int n = data.readInt();
                    }
                }
            }
            if (messageTypeId == 8) {
                short worldNameLen = data.readShort();
                data.skipBytes(worldNameLen);
                int bufferId = data.readInt();
                int numBeacons = data.readInt();
                for (int i = 0; i < numBeacons; ++i) {
                    int x = data.readInt();
                    data.setInt(data.readerIndex() - 4, x - offset.x());
                    int y = data.readInt();
                    int z2 = data.readInt();
                    data.setInt(data.readerIndex() - 4, z2 - offset.z());
                    z = data.readInt();
                }
            }
            if (messageTypeId == 9) {
                int bufferId = data.readInt();
                int dataLength = data.readInt();
                boolean isFirst = data.getBoolean(data.capacity() - 1);
                if (isFirst) {
                    long sectionPosition = data.getLong(data.readerIndex());
                    DhSectionPosition sectionPositionObj = DhSectionPosition.fromLong(sectionPosition);
                    DhSectionPosition offsetted = sectionPositionObj.offset(offset);
                    long offsettedLong = offsetted.toLong();
                    data.setLong(data.readerIndex(), offsettedLong);
                }
            }
            data.release();
        }
    }

    public class Client
    extends OffsetterPluginMessage.PluginOffsetter.Client {
        @Override
        public void offset(WrapperPlayClientPluginMessage packet, FixedOffset offset, User user) {
            ByteBuf data = Unpooled.wrappedBuffer(packet.getData());
            short protocolVersion = data.readShort();
            short messageTypeId = data.readShort();
            if (messageTypeId == 3 && CoordinateOffsetCore.get().isDebugEnabled()) {
                PluginOffsetterDistantHorizons.printConfig(data, true);
            }
            if (messageTypeId == 6) {
                int tracker = data.readInt();
                short worldNameLen = data.readShort();
                data.skipBytes(worldNameLen);
                long sectionPosition = data.getLong(data.readerIndex());
                DhSectionPosition sectionPositionObj = DhSectionPosition.fromLong(sectionPosition);
                DhSectionPosition unOffsetted = sectionPositionObj.offset(offset.negate());
                if (unOffsetted != null) {
                    long unOffsettedLong = unOffsetted.toLong();
                    data.setLong(data.readerIndex(), unOffsettedLong);
                } else if (sectionPositionObj.detailLevel() != 6) {
                    packet.setChannelName("distant_horizons:message_cancelled_by_coordinateoffset");
                    this.sendDHExceptionMessage(user, protocolVersion, tracker, 3, "Only detail level 6 is supported");
                } else {
                    packet.setChannelName("distant_horizons:message_cancelled_by_coordinateoffset");
                    this.sendDHExceptionMessage(user, protocolVersion, tracker, 2, "Incompatible with current coordinate offset");
                    PlayerWarningCache warningCache = PluginOffsetterDistantHorizons.this.playerWarningCache.computeIfAbsent(user.getUUID(), k -> new PlayerWarningCache());
                    if (!warningCache.hasWarnedOffsetMultiple) {
                        warningCache.hasWarnedOffsetMultiple = true;
                        CoordinateOffsetCore.get().getLogger().warning("Player " + user.getName() + " has Distant Horizons installed, but has an active coordinate offset " + String.valueOf(offset) + " which is not a multiple of 64 blocks. The Distant Horizons plugin will NOT send any data to this player. To fix this, you will need to alter their coordinate offset so that both components are evenly divisible by 64.");
                    }
                }
            }
            data.release();
        }

        private void sendDHExceptionMessage(User user, short protocolVersion, int tracker, int exceptionType, String message) {
            ByteBuf responseData = Unpooled.buffer();
            responseData.writeShort(protocolVersion);
            responseData.writeShort(5);
            responseData.writeInt(tracker);
            responseData.writeInt(exceptionType);
            responseData.writeShort((short)message.length());
            responseData.writeCharSequence(message, StandardCharsets.UTF_8);
            byte[] responseDataArray = new byte[responseData.readableBytes()];
            responseData.readBytes(responseDataArray);
            WrapperPlayServerPluginMessage responseMsg = new WrapperPlayServerPluginMessage(PluginOffsetterDistantHorizons.CHANNEL, responseDataArray);
            user.sendPacket((PacketWrapper)responseMsg);
            responseData.release();
        }
    }

    private static class PlayerWarningCache {
        boolean hasWarnedProtocolVersion = false;
        boolean hasWarnedOffsetMultiple = false;

        private PlayerWarningCache() {
        }
    }

    record DhSectionPosition(int detailLevel, int x, int z) {
        static DhSectionPosition fromLong(long sectionPosition) {
            int z;
            int detailLevel = (int)(sectionPosition & 0xFFL);
            int x = (int)(sectionPosition >> 8 & 0xFFFFFFFL);
            if ((x & 0x8000000) != 0) {
                x |= 0xF0000000;
            }
            if (((z = (int)(sectionPosition >> 36 & 0xFFFFFFFL)) & 0x8000000) != 0) {
                z |= 0xF0000000;
            }
            return new DhSectionPosition(detailLevel, x, z);
        }

        long toLong() {
            long data = 0L;
            data |= (long)this.detailLevel & 0xFFL;
            data |= ((long)this.x & 0xFFFFFFFL) << 8;
            return data |= ((long)this.z & 0xFFFFFFFL) << 36;
        }

        @Nullable DhSectionPosition offset(FixedOffset offset) {
            if (offset.x() % (1 << this.detailLevel) != 0) {
                return null;
            }
            if (offset.z() % (1 << this.detailLevel) != 0) {
                return null;
            }
            return new DhSectionPosition(this.detailLevel, this.x - (offset.x() >> this.detailLevel), this.z - (offset.z() >> this.detailLevel));
        }
    }
}

