/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.api.CoordinateOffset;
import org.checkerframework.dataflow.qual.Pure;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface Offset
permits FixedOffset, ScalableOffset {
    public static final FixedOffset ZERO = new FixedOffset(0, 0);
    @Deprecated(forRemoval=true)
    public static final int ALIGN_DEFAULT_OVERWORLD = 3;

    public static FixedOffset fixed(int x, int z) {
        return new FixedOffset(x, z);
    }

    public static ScalableOffset scalable(int x, int z) {
        return new ScalableOffset(x, z);
    }

    public static ScalableOffset align(int x, int z) {
        return new ScalableOffset(Offset.alignComponentToConfiguredMultiple(x), Offset.alignComponentToConfiguredMultiple(z));
    }

    @Deprecated(forRemoval=true)
    public static ScalableOffset align(int x, int z, int toChunksPower) {
        return new ScalableOffset(Offset.alignComponent(x, toChunksPower), Offset.alignComponent(z, toChunksPower));
    }

    public static ScalableOffset random(int bound) {
        return new ScalableOffset(Offset.alignComponentToConfiguredMultiple(ScalableOffset.RANDOM.nextInt(bound)), Offset.alignComponentToConfiguredMultiple(ScalableOffset.RANDOM.nextInt(bound)));
    }

    @Deprecated(forRemoval=true)
    public static ScalableOffset random(int bound, int alignToChunksPower) {
        return new ScalableOffset(Offset.alignComponent(ScalableOffset.RANDOM.nextInt(bound), alignToChunksPower), Offset.alignComponent(ScalableOffset.RANDOM.nextInt(bound), alignToChunksPower));
    }

    public static int alignComponent(int component, int alignToChunksPower) {
        return Math.round((float)component / (float)(1 << alignToChunksPower + 4)) * (1 << alignToChunksPower + 4);
    }

    public static int alignComponentToConfiguredMultiple(int component) {
        int configuredMultiple = CoordinateOffset.api().getConfig().getOffsetsAreMultiplesOfBlocks();
        return Math.round((float)component / (float)configuredMultiple) * configuredMultiple;
    }

    @Pure
    public <T> T apply(T var1) throws ClassCastException;

    @Pure
    public <T> T unapply(T var1) throws ClassCastException;

    @Pure
    public Offset negate();

    public boolean isZero();
}

