/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.provider.CoreOffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PermissionOffsetProvider
extends CoreOffsetProvider {
    private final String prefix;
    private final Pattern pattern;

    PermissionOffsetProvider(String name, String prefix) {
        super(name);
        this.prefix = prefix;
        this.pattern = Pattern.compile(Pattern.quote(prefix) + "\\.(-?\\d+)\\.(-?\\d+)");
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        Set<String> allPerms = context.player().getAllPermissions();
        Set matchingPerms = allPerms.stream().filter(perm -> perm.startsWith(this.prefix)).collect(Collectors.toSet());
        HashSet<ScalableOffset> offsets = new HashSet<ScalableOffset>();
        for (String perm2 : matchingPerms) {
            try {
                ScalableOffset alignedOffset;
                int z;
                Matcher matcher = this.pattern.matcher(perm2);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Pattern \"" + this.pattern.pattern() + "\" does not match permission \"" + perm2 + "\"");
                }
                int x = Integer.parseInt(matcher.group(1));
                ScalableOffset directOffset = Offset.scalable(x, z = Integer.parseInt(matcher.group(2)));
                if (!directOffset.equals(alignedOffset = Offset.align(x, z))) {
                    CoordinateOffsetCore.get().getLogger().warning("Provider \"" + this.name + "\": Offset defined in " + context.player().getName() + "'s permission \"" + perm2 + "\" contains a component which is not a multiple of " + CoordinateOffsetCore.get().getConfig().getOffsetsAreMultiplesOfBlocks() + " blocks; the offset will be rounded to " + String.valueOf(alignedOffset) + " to match the configured offsetsAreMultiplesOfBlocks setting. Change the permission to \"" + this.prefix + "." + alignedOffset.x() + "." + alignedOffset.z() + "\" to hide this warning.");
                }
                offsets.add(alignedOffset);
            }
            catch (Exception e) {
                String message = "Provider \"" + this.name + "\": Failed to decode permission \"" + perm2 + "\" for player " + context.player().getName() + "; ensure all permissions starting with \"" + this.prefix + "\" are formatted like \"" + this.prefix + ".x.z\".";
                if (CoordinateOffsetCore.get().isDebugEnabled()) {
                    new IllegalArgumentException(message, e).printStackTrace();
                    continue;
                }
                CoordinateOffsetCore.get().getLogger().warning(message);
            }
        }
        List sortedOffsets = offsets.stream().sorted((o1, o2) -> {
            if (o1.x() == o2.x()) {
                return Integer.compare(o1.z(), o2.z());
            }
            return Integer.compare(o1.x(), o2.x());
        }).toList();
        if (sortedOffsets.isEmpty()) {
            CoordinateOffsetCore.get().getLogger().warning("Provider \"" + this.name + "\": Player " + context.player().getName() + " has no permission matching \"" + this.prefix + ".x.z\". The player will receive no offset. Give this player permission \"" + this.prefix + ".0.0\" to accept zero offset and hide this warning.");
            return Offset.ZERO;
        }
        if (sortedOffsets.size() == 1) {
            return (Offset)sortedOffsets.getFirst();
        }
        CoordinateOffsetCore.get().getLogger().warning("Provider \"" + this.name + "\": Player " + context.player().getName() + " has permissions for multiple offsets: " + sortedOffsets.stream().map(ScalableOffset::toString).collect(Collectors.joining(", ")) + ". The first offset listed will be used. Remove the conflicting permissions of format \"" + this.prefix + ".x.z\" to hide this warning.");
        return (Offset)sortedOffsets.getFirst();
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("prefix", this.prefix);
        return map;
    }

    public static PermissionOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        SequencedMap<String, Object> s = config.getConfigSection();
        if (!s.containsKey("prefix")) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + ": Required key prefix for PermissionOffsetProvider is missing or invalid.");
        }
        String prefix = s.get("prefix").toString().replaceAll("\\.+$", "");
        return new PermissionOffsetProvider(config.getUserDefinedProviderName(), prefix);
    }

    @Override
    public String getMetricsClassName() {
        return "PermissionOffsetProvider";
    }

    @Override
    public String getMetricsDetails() {
        return this.getMetricsClassName();
    }
}

