/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.adapter.OffsetPersistenceAdapter;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.lib.com.jeff_media.morepersistentdatatypes.DataType;
import com.jtprince.coordinateoffset.lib.com.jeff_media.morepersistentdatatypes.datatypes.GenericDataType;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperPlayerOffsetPersistence
implements OffsetPersistenceAdapter {
    private static final PersistentDataType<int[], ScalableOffset> PDT_OFFSET = new GenericDataType<int[], ScalableOffset>(DataType.INTEGER_ARRAY.getPrimitiveType(), ScalableOffset.class, PaperPlayerOffsetPersistence::fromPdt, PaperPlayerOffsetPersistence::toPdt);
    private final CoordinateOffsetPaperPlugin plugin;
    private final PreV6 preV6 = new PreV6();

    public PaperPlayerOffsetPersistence(CoordinateOffsetPaperPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @Nullable ScalableOffset get(OffsetPlayer player, OffsetPersistenceAdapter.Key persistenceKey) {
        if (!(player instanceof PaperOffsetPlayer)) {
            throw new IllegalArgumentException("Player must be an instance of PaperOffsetPlayer");
        }
        PaperOffsetPlayer paperPlayer = (PaperOffsetPlayer)player;
        PersistentDataContainer pdc = paperPlayer.getPlayer().getPersistentDataContainer();
        if (pdc.has(this.persistenceKeyToBukkitKey(persistenceKey), PDT_OFFSET)) {
            return (ScalableOffset)pdc.get(this.persistenceKeyToBukkitKey(persistenceKey), PDT_OFFSET);
        }
        ScalableOffset recovered = this.preV6.recover(paperPlayer.getPlayer(), persistenceKey);
        if (recovered != null) {
            this.put(paperPlayer, persistenceKey, recovered);
        }
        return recovered;
    }

    @Override
    public void put(OffsetPlayer player, OffsetPersistenceAdapter.Key persistenceKey, ScalableOffset offset) {
        if (!(player instanceof PaperOffsetPlayer)) {
            throw new IllegalArgumentException("Player must be an instance of PaperOffsetPlayer");
        }
        PaperOffsetPlayer paperPlayer = (PaperOffsetPlayer)player;
        paperPlayer.getPlayer().getPersistentDataContainer().set(this.persistenceKeyToBukkitKey(persistenceKey), PDT_OFFSET, (Object)offset);
    }

    @Override
    public void clear(UUID playerUuid, OffsetPersistenceAdapter.Key persistenceKey) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
            this.plugin.getLogger().warning("Failed to clear persistent offset for offline player " + offlinePlayer.getName() + " (" + String.valueOf(playerUuid) + ")");
            return;
        }
        player.getPersistentDataContainer().remove(this.persistenceKeyToBukkitKey(persistenceKey));
        this.preV6.clearOldPersistence(player, persistenceKey);
    }

    private static ScalableOffset fromPdt(int[] arr) {
        return Offset.scalable(arr[0], arr[1]);
    }

    private static int[] toPdt(ScalableOffset offset) {
        return new int[]{offset.x(), offset.z()};
    }

    private NamespacedKey persistenceKeyToBukkitKey(OffsetPersistenceAdapter.Key persistenceKey) {
        return new NamespacedKey((Plugin)this.plugin, persistenceKey.getPersistenceKey());
    }

    private class PreV6 {
        private static final PersistentDataType<PersistentDataContainer, Map<String, ScalableOffset>> PDT_WORLD_OFFSET_CONTAINER = DataType.asMap(DataType.STRING, PDT_OFFSET);
        private static final String OLD_KEY_PREFIX = "random-persistence.";
        private static final String MIGRATED_KEY_SUFFIX = ".old-migrated-v6";

        private PreV6() {
        }

        @Nullable ScalableOffset recover(Player player, OffsetPersistenceAdapter.Key persistenceKey) {
            try {
                Object key = null;
                NamespacedKey fullKey = null;
                Map foundData = null;
                if (persistenceKey.persistenceKeyOverride() != null) {
                    key = OLD_KEY_PREFIX + persistenceKey.persistenceKeyOverride();
                    fullKey = new NamespacedKey((Plugin)PaperPlayerOffsetPersistence.this.plugin, (String)key);
                    foundData = (Map)player.getPersistentDataContainer().get(fullKey, PDT_WORLD_OFFSET_CONTAINER);
                }
                if (foundData == null) {
                    key = "random-persistence.default";
                    fullKey = new NamespacedKey((Plugin)PaperPlayerOffsetPersistence.this.plugin, (String)key);
                    foundData = (Map)player.getPersistentDataContainer().get(fullKey, PDT_WORLD_OFFSET_CONTAINER);
                }
                if (foundData == null) {
                    return null;
                }
                ScalableOffset offset = this.find(player, foundData);
                if (offset != null) {
                    NamespacedKey oldKey = new NamespacedKey((Plugin)PaperPlayerOffsetPersistence.this.plugin, (String)key + MIGRATED_KEY_SUFFIX);
                    player.getPersistentDataContainer().set(oldKey, PDT_WORLD_OFFSET_CONTAINER, (Object)foundData);
                    player.getPersistentDataContainer().remove(fullKey);
                }
                return offset;
            }
            catch (Exception e) {
                PaperPlayerOffsetPersistence.this.plugin.getLogger().warning("Failed to recover old persistent offset for " + player.getName());
                PaperPlayerOffsetPersistence.this.plugin.getLogger().warning("This is a bug, please report it to the developer.");
                e.printStackTrace();
                return null;
            }
        }

        private @Nullable ScalableOffset find(Player player, Map<String, ScalableOffset> map) {
            for (World w : Bukkit.getWorlds()) {
                if (w.getCoordinateScale() != 1.0 || !map.containsKey(w.getName())) continue;
                return map.get(w.getName());
            }
            for (World w : Bukkit.getWorlds()) {
                if (!map.containsKey(w.getName())) continue;
                ScalableOffset saved = map.get(w.getName());
                ScalableOffset scaledUp = Offset.scalable((int)((double)saved.x() * w.getCoordinateScale()), (int)((double)saved.z() * w.getCoordinateScale()));
                CoordinateOffsetCore.get().getLogger().warning("Migrating old format of a persistent random offset for " + player.getName() + " from world " + w.getName() + " - this may not be accurate (scaling it by " + w.getCoordinateScale() + " to make " + String.valueOf(scaledUp) + "). Manually change this with /offset set if this is not what you want.");
                return scaledUp;
            }
            Iterator<Object> iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                CoordinateOffsetCore.get().getLogger().warning("Migrating old format of a persistent random offset for " + player.getName() + " from world " + (String)entry.getKey() + " - this is almost certainly inaccurate. Taking " + String.valueOf(entry.getValue()) + ". Manually change this with /offset set if this is not what you want.");
                return (ScalableOffset)entry.getValue();
            }
            return null;
        }

        private void clearOldPersistence(Player player, OffsetPersistenceAdapter.Key persistenceKey) {
            NamespacedKey fullKey;
            Object key;
            if (persistenceKey.persistenceKeyOverride() != null) {
                key = OLD_KEY_PREFIX + persistenceKey.persistenceKeyOverride();
                fullKey = new NamespacedKey((Plugin)PaperPlayerOffsetPersistence.this.plugin, (String)key);
                player.getPersistentDataContainer().remove(fullKey);
            }
            key = "random-persistence.default";
            fullKey = new NamespacedKey((Plugin)PaperPlayerOffsetPersistence.this.plugin, (String)key);
            player.getPersistentDataContainer().remove(fullKey);
        }
    }
}

