/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUnloadChunk;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateViewPosition;
import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.adapter.OffsetSwapper;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import io.papermc.paper.FeatureHooks;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperOffsetSwapper
implements OffsetSwapper,
Listener {
    private final CoordinateOffsetPaperPlugin plugin;
    private static final long HEADROOM_NS = 2000000L;
    private final Map<UUID, ChunkRefreshTask> chunkRefreshTasks = new HashMap<UUID, ChunkRefreshTask>();
    private int lastTickExceptionPrinted = 0;

    public PaperOffsetSwapper(CoordinateOffsetPaperPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void forceOffsetSwap(OffsetPlayer offsetPlayer) {
        Player player = (Player)offsetPlayer.getPlatformPlayerObject();
        List<Chunk> chunksClosestFirst = this.sendUnloadAllSentChunksPackets(player);
        player.setPlayerProfile(player.getPlayerProfile());
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)new WrapperPlayServerUpdateViewPosition(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ()));
        this.refreshChunksAndEntities(player, chunksClosestFirst);
    }

    public List<Chunk> getSentChunksClosestFirst(Player player) {
        int cx = player.getChunk().getX();
        int cz = player.getChunk().getZ();
        return player.getSentChunks().stream().sorted(Comparator.comparing(c -> (c.getX() - cx) * (c.getX() - cx) + (c.getZ() - cz) * (c.getZ() - cz))).toList();
    }

    public List<Chunk> sendUnloadAllSentChunksPackets(Player player) {
        List<Chunk> chunksClosestFirst = this.getSentChunksClosestFirst(player);
        for (Chunk chunk : chunksClosestFirst.reversed()) {
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)new WrapperPlayServerUnloadChunk(chunk.getX(), chunk.getZ()));
        }
        return chunksClosestFirst;
    }

    public void refreshChunksAndEntities(Player player, List<Chunk> chunks) {
        this.chunkRefreshTasks.put(player.getUniqueId(), new ChunkRefreshTask(Bukkit.getCurrentTick(), player.getWorld().getUID(), new ArrayDeque<Chunk>(chunks), player.getWorld().getEntities().stream().filter(e -> e.getTrackedBy().contains(player)).map(Entity::getUniqueId).collect(Collectors.toSet())));
    }

    @EventHandler
    public void onTickEnd(ServerTickEndEvent event) {
        ArrayDeque<UUID> toRemove = new ArrayDeque<UUID>();
        do {
            for (UUID playerUuid : this.chunkRefreshTasks.keySet()) {
                Player player = Bukkit.getPlayer((UUID)playerUuid);
                ChunkRefreshTask task = this.chunkRefreshTasks.get(playerUuid);
                if (player == null) {
                    toRemove.add(playerUuid);
                    continue;
                }
                Chunk chunk = task.chunksLeft().poll();
                if (chunk == null) {
                    for (UUID entityId : task.entitiesLeft()) {
                        Entity entity = Bukkit.getEntity((UUID)entityId);
                        if (entity == null) continue;
                        player.hideEntity((Plugin)this.plugin, entity);
                        player.showEntity((Plugin)this.plugin, entity);
                    }
                    toRemove.add(playerUuid);
                    continue;
                }
                if (player.isChunkSent(chunk)) {
                    this.refreshChunkForPlayer(player, chunk);
                }
                for (Entity entity : chunk.getEntities()) {
                    if (task.entitiesLeft.contains(entity.getUniqueId()) && entity.getTrackedBy().contains(player)) {
                        player.hideEntity((Plugin)this.plugin, entity);
                        player.showEntity((Plugin)this.plugin, entity);
                    }
                    task.entitiesLeft.remove(entity.getUniqueId());
                }
            }
            while (!toRemove.isEmpty()) {
                UUID playerUuid = (UUID)toRemove.remove();
                if (CoordinateOffsetCore.get().isDebugEnabled()) {
                    CoordinateOffsetCore.get().getLogger().info("Chunks refreshed in " + (Bukkit.getCurrentTick() - this.chunkRefreshTasks.get((Object)playerUuid).startTick) + " ticks for " + String.valueOf(playerUuid));
                }
                this.chunkRefreshTasks.remove(playerUuid);
            }
        } while (event.getTimeRemaining() > 2000000L && !this.chunkRefreshTasks.isEmpty());
    }

    private void refreshChunkForPlayer(Player player, Chunk chunk) {
        try {
            FeatureHooks.sendChunkRefreshPackets(List.of(((CraftPlayer)player).getHandle()), (LevelChunk)((LevelChunk)((CraftChunk)chunk).getHandle(ChunkStatus.FULL)));
        }
        catch (Exception e) {
            if (Bukkit.getCurrentTick() - this.lastTickExceptionPrinted > 10) {
                new RuntimeException("Failed to refresh " + String.valueOf(chunk) + " for " + player.getName() + "; falling back on refreshing chunk for all players", e).printStackTrace();
                this.lastTickExceptionPrinted = Bukkit.getCurrentTick();
            }
            chunk.getWorld().refreshChunk(chunk.getX(), chunk.getZ());
        }
    }

    private record ChunkRefreshTask(int startTick, UUID world, Queue<Chunk> chunksLeft, Set<UUID> entitiesLeft) {
    }
}

