/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateViewPosition;
import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.OffsetChange;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.WorldBorderObfuscator;
import com.jtprince.coordinateoffset.paper.adapter.PaperLocation;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetSwapper;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
class BukkitEventListener
implements Listener {
    private final CoordinateOffsetPaperPlugin plugin;
    private final CoordinateOffsetCore core;
    private final WorldBorderObfuscator worldBorderObfuscator;
    private final Map<UUID, Location> lastDeathLocation = new HashMap<UUID, Location>();
    private static final Set<String> IGNORED_TELEPORT_CAUSES = Set.of("DISMOUNT", "EXIT_BED", "END_PORTAL", "UNKNOWN");

    BukkitEventListener(CoordinateOffsetPaperPlugin plugin, CoordinateOffsetCore core, WorldBorderObfuscator worldBorderObfuscator) {
        this.plugin = plugin;
        this.core = core;
        this.worldBorderObfuscator = worldBorderObfuscator;
    }

    public void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLoad(ServerLoadEvent event) {
        this.plugin.onAllPluginsEnabled();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        PaperOffsetPlayer player = new PaperOffsetPlayer(event.getPlayer());
        this.core.getOffsetHolder().generateNextOffset(player, null, new PaperLocation(event.getPlayer().getLocation()), OffsetProviderContext.ProvideReason.JOIN);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.lastDeathLocation.put(event.getEntity().getUniqueId(), event.getEntity().getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        OffsetProviderContext.ProvideReason reason = event.getRespawnReason() == PlayerRespawnEvent.RespawnReason.END_PORTAL ? OffsetProviderContext.ProvideReason.WORLD_CHANGE : OffsetProviderContext.ProvideReason.DEATH_RESPAWN;
        Location lastDeathLocation = this.lastDeathLocation.get(event.getPlayer().getUniqueId());
        PaperOffsetPlayer player = new PaperOffsetPlayer(event.getPlayer());
        this.core.getOffsetHolder().generateNextOffset(player, lastDeathLocation == null ? null : new PaperLocation(lastDeathLocation), new PaperLocation(event.getRespawnLocation()), reason);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        PaperOffsetPlayer offsetPlayer = new PaperOffsetPlayer(event.getPlayer());
        if (IGNORED_TELEPORT_CAUSES.contains(event.getCause().name())) {
            if (this.core.isDebugEnabled()) {
                this.core.getLogger().info("Ignoring teleport event for " + event.getPlayer().getName() + " due to ignored cause: " + event.getCause().name());
            }
            return;
        }
        OffsetProviderContext.ProvideReason reason = !event.getFrom().getWorld().equals((Object)event.getTo().getWorld()) ? OffsetProviderContext.ProvideReason.WORLD_CHANGE : OffsetProviderContext.ProvideReason.TELEPORT;
        OffsetChange result = this.core.getOffsetHolder().generateNextOffset(offsetPlayer, new PaperLocation(event.getFrom()), new PaperLocation(event.getTo()), reason);
        if (result.offsetChanged() && reason == OffsetProviderContext.ProvideReason.TELEPORT) {
            int viewDistanceChunks = Math.max(event.getPlayer().getViewDistance(), event.getPlayer().getSendViewDistance()) + 2;
            double viewDistanceBlocks = (double)viewDistanceChunks * 16.0;
            double tpDistanceSq = event.getFrom().distanceSquared(event.getTo());
            if (tpDistanceSq < viewDistanceBlocks * viewDistanceBlocks) {
                List<Chunk> chunksClosestFirst = ((PaperOffsetSwapper)this.core.getAdapter().getOffsetSwapper()).sendUnloadAllSentChunksPackets(event.getPlayer());
                UUID playerId = event.getPlayer().getUniqueId();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player == null) {
                        return;
                    }
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)new WrapperPlayServerUpdateViewPosition(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ()));
                    ((PaperOffsetSwapper)this.core.getAdapter().getOffsetSwapper()).refreshChunksAndEntities(player, chunksClosestFirst);
                }, 1L);
            }
        }
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        for (OffsetProvider provider : this.core.getProviderConfig().getAllOffsetProviderConfigs().values()) {
            try {
                provider.onPlayerQuit(new PaperOffsetPlayer(event.getPlayer()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

