/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.server;

import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.waypoint.AzimuthWaypointInfo;
import com.github.retrooper.packetevents.protocol.world.waypoint.ChunkWaypointInfo;
import com.github.retrooper.packetevents.protocol.world.waypoint.EmptyWaypointInfo;
import com.github.retrooper.packetevents.protocol.world.waypoint.TrackedWaypoint;
import com.github.retrooper.packetevents.protocol.world.waypoint.Vec3iWaypointInfo;
import com.github.retrooper.packetevents.protocol.world.waypoint.WaypointInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWaypoint;
import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.offsetter.PacketOffsetter;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsetterServerWaypoint
extends PacketOffsetter<WrapperPlayServerWaypoint> {
    public OffsetterServerWaypoint() {
        super(WrapperPlayServerWaypoint.class, new PacketTypeCommon[]{PacketType.Play.Server.WAYPOINT});
    }

    @Override
    public void offset(WrapperPlayServerWaypoint packet, FixedOffset offset, User user) {
        Vec3iWaypointInfo newInfo;
        TrackedWaypoint waypoint = packet.getWaypoint();
        WaypointInfo oldInfo = waypoint.getInfo();
        if (oldInfo instanceof Vec3iWaypointInfo) {
            Vec3iWaypointInfo info = (Vec3iWaypointInfo)oldInfo;
            newInfo = new Vec3iWaypointInfo(OffsetterServerWaypoint.apply(info.getPosition(), offset));
        } else if (oldInfo instanceof ChunkWaypointInfo) {
            ChunkWaypointInfo info = (ChunkWaypointInfo)oldInfo;
            newInfo = new ChunkWaypointInfo(OffsetterServerWaypoint.applyChunkX(info.getChunkX(), offset), OffsetterServerWaypoint.applyChunkZ(info.getChunkZ(), offset));
        } else {
            if (oldInfo instanceof AzimuthWaypointInfo || oldInfo instanceof EmptyWaypointInfo) {
                return;
            }
            CoordinateOffsetCore.get().getLogger().warning("Unknown waypoint type: " + oldInfo.getClass().getName());
            return;
        }
        packet.setWaypoint(new TrackedWaypoint(waypoint.getIdentifier(), waypoint.getIcon(), (WaypointInfo)newInfo));
    }
}

