/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.plugin;

import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.offsetter.PacketOffsetter;
import com.jtprince.coordinateoffset.offsetter.plugin.PluginOffsetterDistantHorizons;
import com.jtprince.coordinateoffset.offsetter.plugin.PluginOffsetterWorldEditCUI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class OffsetterPluginMessage {
    private static final List<PluginOffsetter> PLUGIN_OFFSETTER_OFFSETTERS = List.of(new PluginOffsetterDistantHorizons(), new PluginOffsetterWorldEditCUI());
    private static final Map<String, PluginOffsetter.Client> byChannelNameClient;
    private static final Map<String, PluginOffsetter.Server> byChannelNameServer;

    private OffsetterPluginMessage() {
    }

    static {
        try {
            byChannelNameClient = new HashMap<String, PluginOffsetter.Client>();
            byChannelNameServer = new HashMap<String, PluginOffsetter.Server>();
            for (PluginOffsetter offsetter : PLUGIN_OFFSETTER_OFFSETTERS) {
                PluginOffsetter.Client client = offsetter.getClientOffsetter();
                PluginOffsetter.Server server = offsetter.getServerOffsetter();
                for (String channel : offsetter.getHandledChannels()) {
                    if (client != null) {
                        byChannelNameClient.put(channel, client);
                    }
                    if (server == null) continue;
                    byChannelNameServer.put(channel, server);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static interface PluginOffsetter {
        public Set<String> getHandledChannels();

        default public @Nullable Client getClientOffsetter() {
            return null;
        }

        default public @Nullable Server getServerOffsetter() {
            return null;
        }

        default public void onUserDisconnect(User user) {
        }

        public static abstract class Server
        extends PacketOffsetter<WrapperPlayServerPluginMessage> {
            public Server() {
                super(WrapperPlayServerPluginMessage.class, new PacketTypeCommon[]{PacketType.Play.Server.PLUGIN_MESSAGE});
            }
        }

        public static abstract class Client
        extends PacketOffsetter<WrapperPlayClientPluginMessage> {
            public Client() {
                super(WrapperPlayClientPluginMessage.class, new PacketTypeCommon[]{PacketType.Play.Client.PLUGIN_MESSAGE});
            }
        }
    }

    public static class Server
    extends PacketOffsetter<WrapperPlayServerPluginMessage> {
        public Server() {
            super(WrapperPlayServerPluginMessage.class, new PacketTypeCommon[]{PacketType.Play.Server.PLUGIN_MESSAGE});
        }

        @Override
        public void offset(WrapperPlayServerPluginMessage packet, FixedOffset offset, User user) {
            PluginOffsetter.Server offsetter = byChannelNameServer.get(packet.getChannelName());
            if (offsetter != null) {
                offsetter.offset(packet, offset, user);
            }
        }
    }

    public static class Client
    extends PacketOffsetter<WrapperPlayClientPluginMessage> {
        public Client() {
            super(WrapperPlayClientPluginMessage.class, new PacketTypeCommon[]{PacketType.Play.Client.PLUGIN_MESSAGE});
        }

        @Override
        public void offset(WrapperPlayClientPluginMessage packet, FixedOffset offset, User user) {
            PluginOffsetter.Client offsetter = byChannelNameClient.get(packet.getChannelName());
            if (offsetter != null) {
                offsetter.offset(packet, offset, user);
            }
        }

        @Override
        public void onUserDisconnect(User user) {
            for (PluginOffsetter offsetter : PLUGIN_OFFSETTER_OFFSETTERS) {
                offsetter.onUserDisconnect(user);
            }
        }
    }
}

