/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.OffsetProviderClassRegistry;
import com.jtprince.coordinateoffset.config.OffsetProviderConfigImpl;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Serializer;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsetProviderListSerializer
implements Serializer<SequencedMap<String, OffsetProvider>, SequencedMap<String, ?>> {
    @Override
    public SequencedMap<String, ?> serialize(SequencedMap<String, OffsetProvider> map) {
        LinkedHashMap providers = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            LinkedHashMap<String, String> serialized = new LinkedHashMap<String, String>();
            serialized.put("class", ((OffsetProvider)entry.getValue()).getClass().getSimpleName());
            serialized.putAll(((OffsetProvider)entry.getValue()).serialize());
            providers.put((String)entry.getKey(), serialized);
        }
        return providers;
    }

    @Override
    public SequencedMap<String, OffsetProvider> deserialize(SequencedMap<String, ?> element) throws IllegalArgumentException {
        if (!CoordinateOffsetCore.get().areAllProvidersLoaded()) {
            throw new IllegalStateException("Cannot deserialize OffsetProvider list until all providers are registered.");
        }
        LinkedHashMap<String, OffsetProvider> providers = new LinkedHashMap<String, OffsetProvider>();
        for (Map.Entry entry : element.entrySet()) {
            Object v;
            Object v2 = entry.getValue();
            if (!(v2 instanceof Map)) {
                throw new IllegalArgumentException("Invalid provider config for key " + (String)entry.getKey());
            }
            Map providerMap = (Map)v2;
            if (!providerMap.containsKey("class") || !((v = providerMap.get("class")) instanceof String)) {
                throw new IllegalArgumentException("Missing or invalid field 'class' for provider \"" + (String)entry.getKey() + "\"");
            }
            String className = (String)v;
            OffsetProviderClassRegistry.RegisteredProviderClass clazz = CoordinateOffsetCore.get().getProviderRegistry().getRegisteredProviderClass(className);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown provider class " + className + " for provider \"" + (String)entry.getKey() + "\"");
            }
            OffsetProviderConfigImpl providerConfig = new OffsetProviderConfigImpl((String)entry.getKey(), className, new LinkedHashMap<String, Object>(providerMap));
            try {
                OffsetProvider provider = clazz.deserializeFunction().apply(providerConfig);
                providers.put((String)entry.getKey(), provider);
            }
            catch (IllegalArgumentException e) {
                String msg = "Failed to read configured offset provider \"" + (String)entry.getKey() + "\" with class " + clazz.className() + ". Check your configuration and look at the error below.";
                throw new IllegalArgumentException(msg, e);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Failed to read configured offset provider \"").append((String)entry.getKey()).append("\" with class ").append(clazz.className()).append(". ");
                if (clazz.isCore()) {
                    msg.append("This is a built-in offset provider, please report this as a bug.");
                } else {
                    msg.append("This is NOT a CoordinateOffset bug! Check with the author of ").append(clazz.className()).append(" before reporting this to CoordinateOffset.");
                }
                throw new IllegalArgumentException(msg.toString(), e);
            }
        }
        return providers;
    }
}

