/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfigBase;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ConfigVersion {
    public static final int CURRENT = 6;
    public static final int ASSUMED_VERSION_IF_MISSING = 4;

    static boolean onLoadBaseConfig(Path configPath, CoordinateOffsetConfigBase config) {
        if (config.configVersion == null) {
            config.configVersion = 4;
        }
        if (config.configVersion < 6) {
            try {
                Path dst = ConfigVersion.getBackupPath(configPath, config.configVersion);
                CoordinateOffsetCore.get().getLogger().info("Detected new configuration version 6; backing up " + String.valueOf(configPath.getFileName()) + " to " + String.valueOf(dst.getFileName()));
                Files.copy(configPath, dst, new CopyOption[0]);
            }
            catch (Exception e) {
                CoordinateOffsetCore.get().getLogger().severe("Failed to back up CoordinateOffset config; leaving file untouched");
                return false;
            }
        }
        if (config.configVersion > 6) {
            CoordinateOffsetCore.get().getLogger().warning("Found config version " + config.configVersion + " which is higher than the version of the plugin; I'll try my best to interpret it but I won't try to upgrade it to the latest config standard.");
            return false;
        }
        return true;
    }

    static Path getBackupPath(Path configPath, int version) {
        String fileName = configPath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        String newName = dotIndex == -1 ? "v" + version + ".old." + fileName : fileName.substring(0, dotIndex) + ".v" + version + ".old" + fileName.substring(dotIndex);
        return configPath.resolveSibling(newName);
    }
}

