/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetWorld;
import com.jtprince.coordinateoffset.api.CoordinateOffset;
import java.util.Random;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record ScalableOffset(int x, int z) implements Offset
{
    static final Random RANDOM = new Random();

    @Override
    public String toString() {
        return "[x=" + this.x + ", z=" + this.z + "]";
    }

    @Override
    public <T> T apply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation applied = l.apply(this.scaleToWorld(l.getWorld()));
        if (location instanceof OffsetLocation) {
            return (T)applied;
        }
        return (T)applied.getPlatformLocationObject();
    }

    @Override
    public <T> T unapply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation unapplied = l.unapply(this.scaleToWorld(l.getWorld()));
        if (location instanceof OffsetLocation) {
            return (T)unapplied;
        }
        return (T)unapplied.getPlatformLocationObject();
    }

    @Override
    public ScalableOffset negate() {
        return new ScalableOffset(-this.x, -this.z);
    }

    @Override
    public boolean isZero() {
        return this.x == 0 && this.z == 0;
    }

    public FixedOffset scaleDownAndRound(double divisor) {
        return new FixedOffset(Offset.alignComponentToConfiguredMultiple((int)((double)this.x / divisor)), Offset.alignComponentToConfiguredMultiple((int)((double)this.z / divisor)));
    }

    @Deprecated(forRemoval=true)
    public FixedOffset scaleDownBy(double divisor) {
        if (divisor == 0.0) {
            return new FixedOffset(0, 0);
        }
        return new FixedOffset(Offset.alignComponent((int)((double)this.x / divisor), 0), Offset.alignComponent((int)((double)this.z / divisor), 0));
    }

    public FixedOffset scaleToWorld(OffsetWorld world) {
        return this.scaleDownAndRound(world.getCoordinateScale());
    }
}

