/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.adapter.OffsetPersistenceAdapter;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ProviderOffsetStore {
    private final OffsetPersistenceAdapter adapter;
    private final OffsetPersistenceAdapter.Key persistenceKey;

    public ProviderOffsetStore(OffsetPersistenceAdapter adapter, String providerName, @Nullable String persistenceKeyOverride) {
        this.adapter = adapter;
        this.persistenceKey = new OffsetPersistenceAdapter.Key(providerName, persistenceKeyOverride);
    }

    public @Nullable ScalableOffset get(OffsetPlayer player) {
        return this.adapter.get(player, this.persistenceKey);
    }

    public void put(OffsetPlayer player, ScalableOffset offset) {
        this.adapter.put(player, this.persistenceKey, offset);
    }

    public void clear(UUID playerUuid) {
        this.adapter.clear(playerUuid, this.persistenceKey);
    }
}

