/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.command.OffsetSetCommand;
import com.jtprince.coordinateoffset.provider.CoreOffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.util.ProviderOffsetStore;
import com.jtprince.coordinateoffset.provider.util.RegenerateConfig;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ZeroAtLocationOffsetProvider
extends CoreOffsetProvider {
    private final RegenerateConfig regenerateConfig;
    private final ProviderOffsetStore offsetStore;

    ZeroAtLocationOffsetProvider(String name, RegenerateConfig regenerateConfig) {
        super(name);
        this.regenerateConfig = regenerateConfig;
        this.offsetStore = new ProviderOffsetStore(CoordinateOffsetCore.get().getAdapter().getPersistenceAdapter(), name, regenerateConfig.persistenceKeyOverride());
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        boolean willRegenerate;
        switch (context.reason()) {
            default: {
                throw new MatchException(null, null);
            }
            case JOIN: {
                boolean bl = this.regenerateConfig.isRegenOnJoin();
                break;
            }
            case DEATH_RESPAWN: {
                boolean bl = this.regenerateConfig.isRegenOnDeath();
                break;
            }
            case WORLD_CHANGE: {
                boolean bl = this.regenerateConfig.isRegenOnWorldChange();
                break;
            }
            case COMMAND_REGENERATE: 
            case PLUGIN_REGENERATE: {
                boolean bl = true;
                break;
            }
            case TELEPORT: {
                Objects.requireNonNull(context.previousLocation());
                Double distanceTeleported = context.playerLocation().getDistance(context.previousLocation());
                Objects.requireNonNull(distanceTeleported);
                boolean bl = this.regenerateConfig.isRegenOnDistantTeleport(distanceTeleported);
                break;
            }
            case COMMAND_SET: 
            case PLUGIN_SET: {
                boolean bl = willRegenerate = false;
            }
        }
        if (willRegenerate) {
            this.offsetStore.clear(context.player().getUuid());
        }
        ScalableOffset offset = this.offsetStore.get(context.player());
        double coordinateScale = context.playerLocation().getWorld().getCoordinateScale();
        if (offset == null) {
            offset = Offset.align((int)(context.playerLocation().getX() * coordinateScale), (int)(context.playerLocation().getZ() * coordinateScale));
            this.offsetStore.put(context.player(), offset);
        }
        return offset;
    }

    @Override
    public void onOffsetSetByCommand(OffsetSetCommand command, OffsetPlayer target) {
        if (CoordinateOffsetCore.get().getConfig().getVerbose()) {
            CoordinateOffsetCore.get().getLogger().info("Provider \"" + this.name + "\": Updating offset for " + target.getName() + " to " + String.valueOf(command.getOffset()));
        }
        this.offsetStore.put(target, command.getOffset());
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.regenerateConfig.serializeTo(map);
        return map;
    }

    public static ZeroAtLocationOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        SequencedMap<String, Object> s = config.getConfigSection();
        RegenerateConfig regenerateConfig = RegenerateConfig.deserialize(config.getUserDefinedProviderName(), s);
        return new ZeroAtLocationOffsetProvider(config.getUserDefinedProviderName(), regenerateConfig);
    }

    @Override
    public String getMetricsClassName() {
        return "ZeroAtLocationOffsetProvider";
    }

    @Override
    public String getMetricsDetails() {
        return "Regenerate on " + this.regenerateConfig.getMetricsCharacterString();
    }
}

