/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.provider.CoreOffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ConstantOffsetProvider
extends CoreOffsetProvider {
    private final @Nullable ScalableOffset offset;

    ConstantOffsetProvider(String name, @Nullable ScalableOffset offset) {
        super(name);
        this.offset = offset;
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        return Objects.requireNonNullElse(this.offset, Offset.ZERO);
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        if (this.offset == null) {
            map.put("offsetX", 0L);
            map.put("offsetZ", 0L);
        } else {
            map.put("offsetX", Long.valueOf(this.offset.x()));
            map.put("offsetZ", Long.valueOf(this.offset.z()));
        }
        return map;
    }

    public static ConstantOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        Object v;
        Object v2;
        SequencedMap<String, Object> s = config.getConfigSection();
        if (!s.containsKey("offsetX") || !((v2 = s.get("offsetX")) instanceof Number)) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": Required key offsetX for ConstantOffsetProvider is missing or invalid.");
        }
        Number offsetXNum = (Number)v2;
        if (!s.containsKey("offsetZ") || !((v = s.get("offsetZ")) instanceof Number)) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": Required key offsetZ for ConstantOffsetProvider is missing or invalid.");
        }
        Number offsetZNum = (Number)v;
        int offsetX = offsetXNum.intValue();
        int offsetZ = offsetZNum.intValue();
        if (Math.abs(offsetX) > OffsetProvider.OFFSET_MAX) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": offsetX value " + offsetX + " is too large! (Max 30M)");
        }
        if (Math.abs(offsetZ) > OffsetProvider.OFFSET_MAX) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": offsetZ value " + offsetZ + " is too large! (Max 30M)");
        }
        if (offsetX == 0 && offsetZ == 0) {
            return new ConstantOffsetProvider(config.getUserDefinedProviderName(), null);
        }
        return new ConstantOffsetProvider(config.getUserDefinedProviderName(), Offset.scalable(offsetX, offsetZ));
    }

    @Override
    public String getMetricsClassName() {
        return "ConstantOffsetProvider";
    }

    @Override
    public String getMetricsDetails() {
        return this.getMetricsClassName();
    }
}

