/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.paper.adapter.PaperLocation;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperOffsetPlayer
implements OffsetPlayer {
    private final Player player;

    public PaperOffsetPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public UUID getUuid() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public Set<String> getAllPermissions() {
        return this.player.getEffectivePermissions().stream().filter(PermissionAttachmentInfo::getValue).map(PermissionAttachmentInfo::getPermission).collect(Collectors.toSet());
    }

    @Override
    public OffsetLocation getLocation() {
        return new PaperLocation(this.player.getLocation());
    }

    public Player getPlatformPlayerObject() {
        return this.player;
    }

    public String toString() {
        return this.player.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperOffsetPlayer)) return false;
        PaperOffsetPlayer p = (PaperOffsetPlayer)obj;
        if (!this.player.equals((Object)p.player)) return false;
        return true;
    }
}

