/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.adapter.CoordinateOffsetAdapter;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperLocation;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetSwapper;
import com.jtprince.coordinateoffset.paper.adapter.PaperPlayerOffsetPersistence;
import java.nio.file.Path;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperAdapter
implements CoordinateOffsetAdapter {
    private final CoordinateOffsetPaperPlugin plugin;
    private final PaperPlayerOffsetPersistence offsetPersistence;
    private final PaperOffsetSwapper offsetSwapper;

    public PaperAdapter(CoordinateOffsetPaperPlugin plugin) {
        this.plugin = plugin;
        this.offsetPersistence = new PaperPlayerOffsetPersistence(plugin);
        this.offsetSwapper = new PaperOffsetSwapper(plugin);
        this.offsetSwapper.initialize();
    }

    @Override
    public Path getConfigDir() {
        return this.plugin.getDataFolder().toPath();
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    public @Nullable PaperOffsetPlayer getPlayer(UUID playerUuid) {
        Player bukkitPlayer = Bukkit.getPlayer((UUID)playerUuid);
        if (bukkitPlayer == null) {
            return null;
        }
        return new PaperOffsetPlayer(bukkitPlayer);
    }

    @Override
    public PaperOffsetPlayer adaptPlayer(Object platformPlayerObject) throws ClassCastException {
        if (!(platformPlayerObject instanceof Player)) {
            throw new ClassCastException("Object \"" + String.valueOf(platformPlayerObject) + "\" of class " + platformPlayerObject.getClass().getName() + " is not a valid Bukkit Player.");
        }
        Player bukkitPlayer = (Player)platformPlayerObject;
        return new PaperOffsetPlayer(bukkitPlayer);
    }

    @Override
    public PaperLocation adaptLocation(Object platformLocationObject) throws ClassCastException {
        if (!(platformLocationObject instanceof Location)) {
            throw new ClassCastException("Object \"" + String.valueOf(platformLocationObject) + "\" of class " + platformLocationObject.getClass().getName() + " is not a valid Bukkit Location.");
        }
        Location bukkitLocation = (Location)platformLocationObject;
        return new PaperLocation(bukkitLocation);
    }

    @Override
    public PaperPlayerOffsetPersistence getPersistenceAdapter() {
        return this.offsetPersistence;
    }

    @Override
    public PaperOffsetSwapper getOffsetSwapper() {
        return this.offsetSwapper;
    }

    @Override
    public void assertMainThread(String methodName) throws IllegalStateException {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Method \"" + methodName + "\" must be called on the main server thread.");
        }
    }

    @Override
    public void shutdown() {
        Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
    }
}

