/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.server;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.offsetter.PacketOffsetter;
import java.util.Optional;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsetterServerEntityMetadata
extends PacketOffsetter<WrapperPlayServerEntityMetadata> {
    public OffsetterServerEntityMetadata() {
        super(WrapperPlayServerEntityMetadata.class, new PacketTypeCommon[]{PacketType.Play.Server.ENTITY_METADATA});
    }

    @Override
    public void offset(WrapperPlayServerEntityMetadata packet, FixedOffset offset, User user) {
        for (EntityData data : packet.getEntityMetadata()) {
            Object value = data.getValue();
            if (value == null) continue;
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                if (!optional.isPresent()) continue;
                data.setValue(Optional.of(OffsetterServerEntityMetadata.applyOffsetToEntityMeta(optional.get(), offset)));
                continue;
            }
            data.setValue(OffsetterServerEntityMetadata.applyOffsetToEntityMeta(value, offset));
        }
    }

    private static Object applyOffsetToEntityMeta(Object object, FixedOffset offset) {
        if (object instanceof Vector3i) {
            Vector3i blockPosition = (Vector3i)object;
            return OffsetterServerEntityMetadata.apply(blockPosition, offset);
        }
        if (object instanceof ItemStack) {
            ItemStack modifiedItemStack = OffsetterServerEntityMetadata.applyItemStack((ItemStack)object, offset);
            if (modifiedItemStack != null) {
                return modifiedItemStack;
            }
            return object;
        }
        return object;
    }
}

