/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.command;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.OffsetChange;
import com.jtprince.coordinateoffset.OffsetData;
import com.jtprince.coordinateoffset.OffsetFactory;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.command.OffsetQueryCommand;
import com.jtprince.coordinateoffset.command.OffsetRegenerateCommand;
import com.jtprince.coordinateoffset.command.OffsetReloadCommand;
import com.jtprince.coordinateoffset.command.OffsetSetCommand;
import com.jtprince.coordinateoffset.config.MessagesConfig;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsetCommandExecutor {
    private final CoordinateOffsetCore core;

    public OffsetCommandExecutor(CoordinateOffsetCore core) {
        this.core = core;
    }

    public Result execute(OffsetReloadCommand command) {
        boolean success = this.core.reloadConfig();
        if (success) {
            this.core.getMessages().reload.success.send((Audience)command.getCommandSender(), new TagResolver[0]);
            return Result.SUCCESS;
        }
        this.core.getMessages().reload.fail.send((Audience)command.getCommandSender(), new TagResolver[0]);
        return Result.FAIL;
    }

    public Result execute(OffsetQueryCommand command) {
        OffsetData offset = this.core.getOffsetHolder().getOffset(command.getTarget());
        OffsetLocation location = command.getTarget().getLocation();
        MessagesConfig.Query.C msgs = command.getCommandSender().isPlayer(command.getTarget()) ? (offset.offset().isZero() ? this.core.getMessages().query.selfNoOffset : this.core.getMessages().query.self) : this.core.getMessages().query.other;
        msgs.offset().send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)command.getTarget().getName())), Placeholder.component((String)"x", (ComponentLike)Component.text((int)offset.offset().x())), Placeholder.component((String)"z", (ComponentLike)Component.text((int)offset.offset().z()))});
        msgs.coordinates().send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)command.getTarget().getName())), Placeholder.component((String)"x", (ComponentLike)Component.text((int)((int)location.getX()))), Placeholder.component((String)"y", (ComponentLike)Component.text((int)((int)location.getY()))), Placeholder.component((String)"z", (ComponentLike)Component.text((int)((int)location.getZ())))});
        if (command.isVerbose()) {
            OffsetData.Source source = offset.source();
            Objects.requireNonNull(source);
            OffsetData.Source source2 = source;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.PermissionBypass.class, OffsetData.Source.BedrockBypass.class, OffsetData.Source.Provider.class, OffsetData.Source.SetCommand.class, OffsetData.Source.PluginSet.class}, (Object)source2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)source2;
                    this.core.getMessages().query.verbose.zeroByPermission.send((Audience)command.getCommandSender(), new TagResolver[0]);
                    break;
                }
                case 1: {
                    OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)source2;
                    this.core.getMessages().query.verbose.zeroByBedrock.send((Audience)command.getCommandSender(), new TagResolver[0]);
                    break;
                }
                case 2: {
                    OffsetData.Source.Provider provider = (OffsetData.Source.Provider)source2;
                    if (provider.overrideRuleIndex() != null) {
                        this.core.getMessages().query.verbose.generatedByProviderOverride.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"provider", (ComponentLike)Component.text((String)provider.provider().name)), Placeholder.component((String)"rule_number", (ComponentLike)Component.text((String)provider.overrideRuleIndex().toString()))});
                        break;
                    }
                    this.core.getMessages().query.verbose.generatedByProviderDefault.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"provider", (ComponentLike)Component.text((String)provider.provider().name))});
                    break;
                }
                case 3: {
                    OffsetData.Source.SetCommand setCommand = (OffsetData.Source.SetCommand)source2;
                    this.core.getMessages().query.verbose.generatedByCommand.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"sender", (ComponentLike)Component.text((String)setCommand.command().getCommandSender().name()))});
                    break;
                }
                case 4: {
                    OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)source2;
                    this.core.getMessages().query.verbose.generatedByPlugin.send((Audience)command.getCommandSender(), new TagResolver[0]);
                }
            }
        }
        return Result.SUCCESS;
    }

    public Result execute(OffsetRegenerateCommand command) {
        ArrayList<OffsetPlayer> successfulTargets = new ArrayList<OffsetPlayer>();
        for (OffsetPlayer target : command.getTargets()) {
            OffsetChange result = this.core.getOffsetHolder().generateNextOffset(target, target.getLocation(), target.getLocation(), OffsetProviderContext.ProvideReason.COMMAND_REGENERATE);
            if (!result.offsetChanged()) {
                OffsetData.Source source;
                Objects.requireNonNull(result.newOffsetData().source());
                int n = 0;
                MessagesConfig.Message msg = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.BedrockBypass.class, OffsetData.Source.PermissionBypass.class, OffsetData.Source.Provider.class, OffsetData.Source.SetCommand.class, OffsetData.Source.PluginSet.class}, (Object)source, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)source;
                        yield this.core.getMessages().regenerate.unchangedBedrock;
                    }
                    case 1 -> {
                        OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)source;
                        yield this.core.getMessages().regenerate.unchangedPermission;
                    }
                    case 2 -> {
                        OffsetData.Source.Provider ignored = (OffsetData.Source.Provider)source;
                        yield this.core.getMessages().regenerate.unchanged;
                    }
                    case 3 -> {
                        OffsetData.Source.SetCommand ignored = (OffsetData.Source.SetCommand)source;
                        yield this.core.getMessages().regenerate.unchanged;
                    }
                    case 4 -> {
                        OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)source;
                        yield this.core.getMessages().regenerate.unchanged;
                    }
                };
                msg.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)target.getName()))});
                continue;
            }
            this.core.getAdapter().getOffsetSwapper().forceOffsetSwap(target);
            successfulTargets.add(target);
        }
        if (successfulTargets.size() == 1) {
            this.core.getMessages().regenerate.successSingle.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)((OffsetPlayer)successfulTargets.getFirst()).getName()))});
        } else if (successfulTargets.size() > 1) {
            this.core.getMessages().regenerate.successMultiple.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"count", (ComponentLike)Component.text((int)successfulTargets.size())), Placeholder.component((String)"targets", (ComponentLike)Component.text((String)successfulTargets.stream().map(OffsetPlayer::getName).collect(Collectors.joining(", "))))});
        }
        return successfulTargets.isEmpty() ? Result.FAIL : Result.SUCCESS;
    }

    public Result execute(OffsetSetCommand command) {
        ArrayList<OffsetPlayer> successfulTargets = new ArrayList<OffsetPlayer>();
        for (OffsetPlayer target : command.getTargets()) {
            OffsetChange result = this.core.getOffsetHolder().setNextOffsetByCommand(target, command);
            Double warnScaling = command.getWarnScaling(target);
            if (warnScaling != null && warnScaling != 1.0) {
                this.core.getMessages().set.warningCoordinateScaling.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)target.getName())), Placeholder.component((String)"scaling", (ComponentLike)Component.text((double)warnScaling)), Placeholder.component((String)"world", (ComponentLike)Component.text((String)target.getLocation().getWorld().getName()))});
            }
            if (!result.offsetChanged()) {
                OffsetData.Source source;
                Objects.requireNonNull(result.newOffsetData().source());
                int n = 0;
                MessagesConfig.Message msg = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.BedrockBypass.class, OffsetData.Source.PermissionBypass.class, OffsetData.Source.Provider.class, OffsetData.Source.SetCommand.class, OffsetData.Source.PluginSet.class}, (Object)source, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)source;
                        yield this.core.getMessages().set.unchangedBedrock;
                    }
                    case 1 -> {
                        OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)source;
                        yield this.core.getMessages().set.unchanged;
                    }
                    case 2 -> {
                        OffsetData.Source.Provider ignored = (OffsetData.Source.Provider)source;
                        yield this.core.getMessages().set.unchanged;
                    }
                    case 3 -> {
                        OffsetData.Source.SetCommand ignored = (OffsetData.Source.SetCommand)source;
                        yield this.core.getMessages().set.unchanged;
                    }
                    case 4 -> {
                        OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)source;
                        yield this.core.getMessages().set.unchanged;
                    }
                };
                msg.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)target.getName()))});
                continue;
            }
            this.core.getAdapter().getOffsetSwapper().forceOffsetSwap(target);
            OffsetProvider notPersistentProvider = command.getOffsetIsNotPersistentForProvider(target);
            if (OffsetFactory.canBypassByPermission(target)) {
                this.core.getMessages().set.warningNotPersistentByPermission.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)target.getName()))});
            } else if (notPersistentProvider != null) {
                this.core.getMessages().set.warningNotPersistentByProvider.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)target.getName())), Placeholder.component((String)"provider", (ComponentLike)Component.text((String)notPersistentProvider.name))});
            }
            successfulTargets.add(target);
        }
        if (successfulTargets.size() == 1) {
            this.core.getMessages().set.successSingle.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"target", (ComponentLike)Component.text((String)((OffsetPlayer)successfulTargets.getFirst()).getName())), Placeholder.component((String)"x", (ComponentLike)Component.text((int)command.getOffset().x())), Placeholder.component((String)"z", (ComponentLike)Component.text((int)command.getOffset().z()))});
        } else if (successfulTargets.size() > 1) {
            this.core.getMessages().set.successMultiple.send((Audience)command.getCommandSender(), new TagResolver[]{Placeholder.component((String)"count", (ComponentLike)Component.text((int)successfulTargets.size())), Placeholder.component((String)"targets", (ComponentLike)Component.text((String)successfulTargets.stream().map(OffsetPlayer::getName).collect(Collectors.joining(", ")))), Placeholder.component((String)"x", (ComponentLike)Component.text((int)command.getOffset().x())), Placeholder.component((String)"z", (ComponentLike)Component.text((int)command.getOffset().z()))});
        }
        return successfulTargets.isEmpty() ? Result.FAIL : Result.SUCCESS;
    }

    public static enum Result {
        SUCCESS,
        FAIL;

    }
}

