/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.api;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetChange;
import com.jtprince.coordinateoffset.OffsetData;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.api.CoordinateOffset;
import com.jtprince.coordinateoffset.api.CoordinateOffsetAPI;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfig;
import com.jtprince.coordinateoffset.config.CoordinateOffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.UUID;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CoordinateOffsetAPIImpl
implements CoordinateOffsetAPI {
    private final CoordinateOffsetCore core;

    public CoordinateOffsetAPIImpl(CoordinateOffsetCore core) {
        this.core = core;
    }

    @Override
    public FixedOffset getOffset(OffsetPlayer player) {
        return this.core.getOffsetHolder().getOffset(player).offset();
    }

    @Override
    public OffsetData getOffsetData(OffsetPlayer player) {
        return this.core.getOffsetHolder().getOffset(player);
    }

    @Override
    public OffsetChange regenerateOffset(OffsetPlayer player) {
        CoordinateOffsetCore.get().getAdapter().assertMainThread("regenerateOffset");
        OffsetChange result = this.core.getOffsetHolder().generateNextOffset(player, player.getLocation(), player.getLocation(), OffsetProviderContext.ProvideReason.PLUGIN_REGENERATE);
        if (result.offsetChanged()) {
            this.core.getAdapter().getOffsetSwapper().forceOffsetSwap(player);
        }
        return result;
    }

    @Override
    public OffsetChange setOffset(OffsetPlayer player, Offset offset) {
        CoordinateOffsetCore.get().getAdapter().assertMainThread("setOffset");
        OffsetChange result = this.core.getOffsetHolder().setNextOffsetByPlugin(player, offset);
        if (result.offsetChanged()) {
            this.core.getAdapter().getOffsetSwapper().forceOffsetSwap(player);
        }
        return result;
    }

    @Override
    public @Nullable OffsetPlayer getPlayer(UUID playerUuid) {
        return this.core.getAdapter().getPlayer(playerUuid);
    }

    @Override
    public OffsetPlayer adaptPlayer(Object platformPlayerObject) throws ClassCastException {
        return this.core.getAdapter().adaptPlayer(platformPlayerObject);
    }

    @Override
    public OffsetLocation adaptLocation(Object platformLocationObject) throws ClassCastException {
        return this.core.getAdapter().adaptLocation(platformLocationObject);
    }

    @Override
    public CoordinateOffsetConfig getConfig() {
        return this.core.getConfig();
    }

    @Override
    public CoordinateOffsetProviderConfig getProviderConfig() {
        return this.core.getProviderConfig();
    }

    @Override
    public void registerOffsetProviderClass(String className, Function<OffsetProviderConfig, OffsetProvider> deserializeFunction) {
        boolean isCore = false;
        this.core.getProviderRegistry().registerProviderClass(className, isCore, deserializeFunction);
    }

    public static void set(CoordinateOffsetAPI api) {
        CoordinateOffset.set(api);
    }
}

